/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.GenericExpressionCompiler;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.value.NodeVariableLong;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;

public class JsonGuiIterator {
    public final String name;
    public final String start;
    public final String step;
    public final String shouldContinue;
    @Nullable
    public final JsonGuiIterator childIterator;

    public JsonGuiIterator(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            this.name = JsonUtils.func_151219_a((JsonObject)obj, (String)"name", (String)"index");
            this.start = JsonUtils.func_151219_a((JsonObject)obj, (String)"start", (String)"0");
            this.step = JsonUtils.func_151200_h((JsonObject)obj, (String)"step");
            if (obj.has("while")) {
                this.shouldContinue = JsonUtils.func_151200_h((JsonObject)obj, (String)"while");
            } else {
                String end = JsonUtils.func_151200_h((JsonObject)obj, (String)"end");
                this.shouldContinue = "step > 0 ? ($name <= $end) : ($name >= $end)".replace("$end", end).replace("$name", this.name);
            }
            this.childIterator = obj.has("iterator") ? new JsonGuiIterator(obj.get("iterator")) : null;
        } else if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            block10: {
                String iter = element.getAsString();
                this.name = iter.substring(0, iter.indexOf(61)).trim();
                String bounds = iter.substring(iter.indexOf(61) + 1).trim();
                this.start = bounds.substring(1, bounds.indexOf(44)).replace(" ", "");
                String end = bounds.substring(bounds.indexOf(44) + 1).trim().replace(" ", "");
                try {
                    int s = Integer.parseInt(this.start) + (this.start.startsWith("(") ? 1 : 0);
                    int e = Integer.parseInt(end.substring(0, end.length() - 1)) - (end.endsWith(")") ? 1 : 0);
                    if (s < e) {
                        this.step = "1";
                        this.shouldContinue = this.name + " <= " + e;
                        break block10;
                    }
                    if (s > e) {
                        this.step = "-1";
                        this.shouldContinue = this.name + " >= " + e;
                        break block10;
                    }
                    throw new JsonSyntaxException("Don't iterate statically from a value to itself!");
                }
                catch (NumberFormatException nfe) {
                    throw new JsonSyntaxException((Throwable)nfe);
                }
            }
            this.childIterator = null;
        } else {
            throw new JsonSyntaxException("Expected an object or a string, got " + element);
        }
    }

    public class ResolvedIterator {
        public final long valStart;
        public final IExpressionNode.INodeLong valStep;
        public final IExpressionNode.INodeBoolean valShouldContinue;
        public final NodeVariableLong value;
        private int count = 0;
        @Nullable
        public final ResolvedIterator child;

        public ResolvedIterator(FunctionContext ctx) {
            try {
                this.valStart = GenericExpressionCompiler.compileExpressionLong(JsonGuiIterator.this.start, ctx).evaluate();
                ctx = new FunctionContext(ctx);
                ctx.putConstantLong("start", this.valStart);
                this.value = ctx.putVariableLong(JsonGuiIterator.this.name);
                this.value.value = this.valStart;
                this.valStep = GenericExpressionCompiler.compileExpressionLong(JsonGuiIterator.this.step, ctx);
                ctx.putVariable("step", this.valStep);
                this.valShouldContinue = GenericExpressionCompiler.compileExpressionBoolean(JsonGuiIterator.this.shouldContinue, ctx);
            }
            catch (InvalidExpressionException iee) {
                throw new JsonSyntaxException("Invalid iterator!", (Throwable)iee);
            }
            if (JsonGuiIterator.this.childIterator == null) {
                this.child = null;
            } else {
                JsonGuiIterator jsonGuiIterator = JsonGuiIterator.this.childIterator;
                jsonGuiIterator.getClass();
                this.child = jsonGuiIterator.new ResolvedIterator(ctx);
            }
        }

        public boolean start() {
            this.value.value = this.valStart;
            boolean canIterate = this.valShouldContinue.evaluate();
            if (this.child != null) {
                canIterate &= this.child.start();
            }
            return canIterate;
        }

        public boolean iterate() {
            long stepValue;
            ++this.count;
            if (this.count > 1000) {
                throw new JsonSyntaxException("Too many total iterations (max 1000)!");
            }
            ResolvedIterator c = this.child;
            if (c != null) {
                if (!c.iterate()) {
                    return false;
                }
                c.value.value = c.valStart;
            }
            if ((stepValue = this.valStep.evaluate()) == 0L) {
                throw new JsonSyntaxException("Step was 0!");
            }
            this.value.value += stepValue;
            return !this.valShouldContinue.evaluate();
        }

        private JsonGuiIterator getJson() {
            return JsonGuiIterator.this;
        }

        public void putProperties(FunctionContext ctx, Map<String, String> properties) {
            ResolvedIterator iter = this;
            while (iter != null) {
                String n = iter.getJson().name;
                ctx.putConstantLong(n, iter.value.value);
                properties.put(n, iter.value.evaluateAsString());
                iter = iter.child;
            }
        }
    }
}

