/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib;

import buildcraft.lib.chunkload.IChunkLoadingTile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumFacing;

public class BCLibConfig {
    public static File guiConfigFile = null;
    public static boolean useColouredLabels = true;
    public static boolean useHighContrastLabelColours = false;
    public static boolean colourBlindMode = false;
    public static int itemLifespan = 60;
    public static boolean useBucketsStatic = true;
    public static boolean useBucketsFlow = true;
    public static boolean useLongLocalizedName = false;
    public static boolean useSwappableSprites = true;
    public static boolean enableAnimatedSprites = true;
    public static int maxGuideSearchCount = 1200;
    public static TimeGap displayTimeGap = TimeGap.SECONDS;
    public static RenderRotation rotateTravelingItems = RenderRotation.ENABLED;
    public static ChunkLoaderType chunkLoadingType = ChunkLoaderType.AUTO;
    public static ChunkLoaderLevel chunkLoadingLevel = ChunkLoaderLevel.SELF_TILES;
    public static boolean guideShowDetail = false;
    public static final List<Runnable> configChangeListeners = new ArrayList<Runnable>();

    public static void refreshConfigs() {
        for (Runnable r : configChangeListeners) {
            r.run();
        }
    }

    public static enum ChunkLoaderLevel {
        NONE,
        STRICT_TILES,
        SELF_TILES,
        ALL_TILES;


        public boolean canLoad(IChunkLoadingTile.LoadType loadType) {
            switch (this) {
                case NONE: {
                    return false;
                }
                case STRICT_TILES: {
                    return loadType == IChunkLoadingTile.LoadType.HARD;
                }
                case SELF_TILES: 
                case ALL_TILES: {
                    return true;
                }
            }
            throw new IllegalStateException("Unknown ChunkLoaderLevel " + (Object)((Object)this));
        }
    }

    public static enum ChunkLoaderType {
        ON,
        AUTO,
        OFF;

    }

    public static enum RenderRotation {
        DISABLED{

            @Override
            public EnumFacing changeFacing(EnumFacing dir) {
                return EnumFacing.EAST;
            }
        }
        ,
        HORIZONTALS_ONLY{

            @Override
            public EnumFacing changeFacing(EnumFacing dir) {
                return dir.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.EAST : dir;
            }
        }
        ,
        ENABLED{

            @Override
            public EnumFacing changeFacing(EnumFacing dir) {
                return dir;
            }
        };


        public abstract EnumFacing changeFacing(EnumFacing var1);
    }

    public static enum TimeGap {
        TICKS(1),
        SECONDS(20);

        private final int ticksInGap;

        private TimeGap(int ticksInGap) {
            this.ticksInGap = ticksInGap;
        }

        public int convertTicksToGap(int ticks) {
            return ticks * this.ticksInGap;
        }

        public long convertTicksToGap(long ticks) {
            return ticks * (long)this.ticksInGap;
        }

        public float convertTicksToGap(float ticks) {
            return ticks * (float)this.ticksInGap;
        }

        public double convertTicksToGap(double ticks) {
            return ticks * (double)this.ticksInGap;
        }
    }
}

