/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.tileentity;

import dmfmm.catwalks.client.catwalks.CatwalkState;
import dmfmm.catwalks.tileentity.CatwalkStateCalculator;
import dmfmm.catwalks.tileentity.IConnectTile;
import dmfmm.catwalks.utils.CatwalkMaterial;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class CatwalkTile
extends TileEntity
implements IConnectTile {
    Map<EnumFacing, Boolean> sides = new HashMap<EnumFacing, Boolean>();
    CatwalkMaterial material = CatwalkMaterial.CLASSIC;

    public CatwalkTile() {
        for (EnumFacing facing : EnumFacing.values()) {
            this.sides.put(facing, true);
        }
    }

    public void updateSide(EnumFacing side, boolean state) {
        this.sides.replace(side, state);
    }

    public boolean getSideState(EnumFacing facing) {
        return this.sides.get(facing);
    }

    public boolean has(EnumFacing side) {
        return this.sides.get(side);
    }

    public CatwalkState getCatwalkState() {
        return new CatwalkStateCalculator(this.func_145831_w(), this.func_174877_v()).calculate();
    }

    public void updateMaterial(String materialName) {
        this.material = CatwalkMaterial.valueOf(materialName.toUpperCase());
    }

    public CatwalkMaterial getMaterial() {
        return this.material;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tag = super.func_189515_b(compound);
        tag.func_74778_a("material", this.getMaterial().func_176610_l());
        for (EnumFacing facing : EnumFacing.values()) {
            tag.func_74757_a(facing.toString(), this.has(facing));
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        String mat = compound.func_74779_i("material");
        if (mat != "") {
            this.material = CatwalkMaterial.valueOf(mat.toUpperCase());
        }
        for (EnumFacing facing : EnumFacing.values()) {
            this.updateSide(facing, compound.func_74767_n(facing.toString()));
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        String mat = tag.func_74779_i("material");
        if (!mat.equals("")) {
            this.material = CatwalkMaterial.valueOf(mat.toUpperCase());
        }
        for (EnumFacing facing : EnumFacing.values()) {
            this.updateSide(facing, tag.func_74767_n(facing.toString()));
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("material", this.getMaterial().func_176610_l().toLowerCase());
        for (EnumFacing facing : EnumFacing.values()) {
            tag.func_74757_a(facing.toString(), this.has(facing));
        }
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }
}

