/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.client;

import com.google.common.collect.ImmutableMap;
import dmfmm.catwalks.block.LadderBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;

public class LadderModel
implements IBakedModel {
    private ImmutableMap<EnumFacing, IBakedModel> rotatedSide;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedLadder;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedWrap;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedRightConnection;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedLeftConnection;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedBase;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedBasePoles;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedBaseConnected;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedBigLeft;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedBigRight;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedBigWrap;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedLadderTop;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedMergeLeft;
    private ImmutableMap<EnumFacing, IBakedModel> rotatedMergeRight;

    public LadderModel(IModel ladder, IModel side, IModel connectionRight, IModel connectionLeft, IModel wrap, IModel base, IModel secondPole, IModel connectedBase, IModel bigLeft, IModel bigRight, IModel bigWrap, IModel ladderTop, IModel mergeLeft, IModel mergeRight, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap.Builder sideBuilder = ImmutableMap.builder();
        ImmutableMap.Builder ladderBuilder = ImmutableMap.builder();
        ImmutableMap.Builder wrapBuilder = ImmutableMap.builder();
        ImmutableMap.Builder rightConBuilder = ImmutableMap.builder();
        ImmutableMap.Builder leftConBuilder = ImmutableMap.builder();
        ImmutableMap.Builder baseBuilder = ImmutableMap.builder();
        ImmutableMap.Builder basePoleBuilder = ImmutableMap.builder();
        ImmutableMap.Builder baseConnectedBuilder = ImmutableMap.builder();
        ImmutableMap.Builder bigLeftBuilder = ImmutableMap.builder();
        ImmutableMap.Builder bigRightBuilder = ImmutableMap.builder();
        ImmutableMap.Builder bigWrapBuilder = ImmutableMap.builder();
        ImmutableMap.Builder ladderTopBuilder = ImmutableMap.builder();
        ImmutableMap.Builder mergeLeftBuilder = ImmutableMap.builder();
        ImmutableMap.Builder mergeRightBuilder = ImmutableMap.builder();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            TRSRTransformation transformation = TRSRTransformation.from((EnumFacing)facing);
            sideBuilder.put((Object)facing, (Object)side.bake((IModelState)transformation, format, bakedTextureGetter));
            ladderBuilder.put((Object)facing, (Object)ladder.bake((IModelState)transformation, format, bakedTextureGetter));
            wrapBuilder.put((Object)facing, (Object)wrap.bake((IModelState)transformation, format, bakedTextureGetter));
            rightConBuilder.put((Object)facing, (Object)connectionRight.bake((IModelState)transformation, format, bakedTextureGetter));
            leftConBuilder.put((Object)facing, (Object)connectionLeft.bake((IModelState)transformation, format, bakedTextureGetter));
            basePoleBuilder.put((Object)facing, (Object)secondPole.bake((IModelState)transformation, format, bakedTextureGetter));
            baseConnectedBuilder.put((Object)facing, (Object)connectedBase.bake((IModelState)transformation, format, bakedTextureGetter));
            bigLeftBuilder.put((Object)facing, (Object)bigLeft.bake((IModelState)transformation, format, bakedTextureGetter));
            bigRightBuilder.put((Object)facing, (Object)bigRight.bake((IModelState)transformation, format, bakedTextureGetter));
            bigWrapBuilder.put((Object)facing, (Object)bigWrap.bake((IModelState)transformation, format, bakedTextureGetter));
            ladderTopBuilder.put((Object)facing, (Object)ladderTop.bake((IModelState)transformation, format, bakedTextureGetter));
            mergeLeftBuilder.put((Object)facing, (Object)mergeLeft.bake((IModelState)transformation, format, bakedTextureGetter));
            mergeRightBuilder.put((Object)facing, (Object)mergeRight.bake((IModelState)transformation, format, bakedTextureGetter));
            Vector3f t = transformation.getTranslation();
            t.add((Tuple3f)new Vector3f(0.0f, 0.06f, 0.0f));
            baseBuilder.put((Object)facing, (Object)base.bake((IModelState)new TRSRTransformation(t, transformation.getLeftRot(), transformation.getScale(), transformation.getRightRot()), format, bakedTextureGetter));
        }
        this.rotatedSide = sideBuilder.build();
        this.rotatedLadder = ladderBuilder.build();
        this.rotatedWrap = wrapBuilder.build();
        this.rotatedRightConnection = rightConBuilder.build();
        this.rotatedLeftConnection = leftConBuilder.build();
        this.rotatedBase = baseBuilder.build();
        this.rotatedBasePoles = basePoleBuilder.build();
        this.rotatedBaseConnected = baseConnectedBuilder.build();
        this.rotatedBigLeft = bigLeftBuilder.build();
        this.rotatedBigRight = bigRightBuilder.build();
        this.rotatedBigWrap = bigWrapBuilder.build();
        this.rotatedLadderTop = ladderTopBuilder.build();
        this.rotatedMergeLeft = mergeLeftBuilder.build();
        this.rotatedMergeRight = mergeRightBuilder.build();
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> bq = new ArrayList<BakedQuad>();
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            LadderBlock.LadderState ladderState = (LadderBlock.LadderState)((Object)ext.getValue(LadderBlock.STATE));
            EnumFacing facing = (EnumFacing)ext.getValue(LadderBlock.FACING);
            switch (ladderState) {
                case MIDDLE: {
                    boolean hasCage = (Boolean)ext.getValue(LadderBlock.HAS_CAGE);
                    bq.addAll(((IBakedModel)this.rotatedLadder.get((Object)facing)).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedSide.get((Object)facing)).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedSide.get((Object)facing.func_176746_e())).func_188616_a(state, side, rand));
                    if (!hasCage) break;
                    bq.addAll(((IBakedModel)this.rotatedWrap.get((Object)facing.func_176734_d())).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedWrap.get((Object)facing.func_176735_f())).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedRightConnection.get((Object)facing.func_176735_f())).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedLeftConnection.get((Object)facing.func_176746_e())).func_188616_a(state, side, rand));
                    break;
                }
                case BOTTOM: {
                    boolean isConnected = (Boolean)ext.getValue(LadderBlock.CONNECTED);
                    bq.addAll(((IBakedModel)this.rotatedLadder.get((Object)facing)).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedSide.get((Object)facing)).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedSide.get((Object)facing.func_176746_e())).func_188616_a(state, side, rand));
                    if (isConnected) {
                        bq.addAll(((IBakedModel)this.rotatedBaseConnected.get((Object)facing.func_176735_f())).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)this.rotatedRightConnection.get((Object)facing.func_176735_f())).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)this.rotatedLeftConnection.get((Object)facing.func_176746_e())).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)this.rotatedRightConnection.get((Object)facing.func_176746_e())).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)this.rotatedLeftConnection.get((Object)facing.func_176735_f())).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)this.rotatedSide.get((Object)facing.func_176734_d())).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)this.rotatedSide.get((Object)facing.func_176735_f())).func_188616_a(state, side, rand));
                        break;
                    }
                    bq.addAll(((IBakedModel)this.rotatedRightConnection.get((Object)facing.func_176735_f())).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedLeftConnection.get((Object)facing.func_176746_e())).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedBase.get((Object)facing)).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedBasePoles.get((Object)facing.func_176735_f())).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedBasePoles.get((Object)facing.func_176746_e())).func_188616_a(state, side, rand));
                    break;
                }
                case TOP: {
                    boolean isConnected = (Boolean)ext.getValue(LadderBlock.CONNECTED);
                    boolean hasCage = (Boolean)ext.getValue(LadderBlock.HAS_CAGE);
                    if (hasCage) {
                        bq.addAll(((IBakedModel)this.rotatedBigWrap.get((Object)facing.func_176734_d())).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)this.rotatedBigWrap.get((Object)facing.func_176735_f())).func_188616_a(state, side, rand));
                    }
                    if (isConnected) {
                        bq.addAll(((IBakedModel)this.rotatedLadderTop.get((Object)facing)).func_188616_a(state, side, rand));
                        if (!hasCage) break;
                        bq.addAll(((IBakedModel)this.rotatedMergeRight.get((Object)facing.func_176735_f())).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)this.rotatedMergeLeft.get((Object)facing.func_176746_e())).func_188616_a(state, side, rand));
                        break;
                    }
                    if (hasCage) {
                        bq.addAll(((IBakedModel)this.rotatedBigRight.get((Object)facing.func_176735_f())).func_188616_a(state, side, rand));
                        bq.addAll(((IBakedModel)this.rotatedBigLeft.get((Object)facing.func_176746_e())).func_188616_a(state, side, rand));
                    }
                    bq.addAll(((IBakedModel)this.rotatedLadder.get((Object)facing)).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedSide.get((Object)facing)).func_188616_a(state, side, rand));
                    bq.addAll(((IBakedModel)this.rotatedSide.get((Object)facing.func_176746_e())).func_188616_a(state, side, rand));
                }
            }
        }
        return bq;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return ((IBakedModel)this.rotatedBase.get((Object)EnumFacing.NORTH)).func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

