/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.block;

import dmfmm.catwalks.block.GenericBlock;
import dmfmm.catwalks.registry.BlockRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class CableBlock
extends GenericBlock {
    public static final AxisAlignedBB CABLE_BOX = new AxisAlignedBB(0.44, 0.0, 0.44, 0.56, 1.0, 0.56);
    public static final AxisAlignedBB CLIP_BOX_NORTH_SOUTH = new AxisAlignedBB(0.23, 0.0, 0.0, 0.75, 0.13, 0.59);
    public static final AxisAlignedBB CLIP_BOX_EAST_WEST = new AxisAlignedBB(0.0, 0.0, 0.23, 0.59, 0.13, 0.75);
    public static final IUnlistedProperty<CableState> STATE = new IUnlistedProperty<CableState>(){

        public String getName() {
            return "cablestate";
        }

        public boolean isValid(CableState value) {
            return true;
        }

        public Class<CableState> getType() {
            return CableState.class;
        }

        public String valueToString(CableState value) {
            return value.toString().toLowerCase();
        }
    };
    public static final IUnlistedProperty<Boolean> CONNECTED = new IUnlistedProperty<Boolean>(){

        public String getName() {
            return "connected";
        }

        public boolean isValid(Boolean value) {
            return true;
        }

        public Class<Boolean> getType() {
            return Boolean.class;
        }

        public String valueToString(Boolean value) {
            return value != false ? "true" : "false";
        }
    };
    public static final IUnlistedProperty<EnumFacing> FACING = new IUnlistedProperty<EnumFacing>(){

        public String getName() {
            return "direction";
        }

        public boolean isValid(EnumFacing value) {
            return value != EnumFacing.UP && value != EnumFacing.DOWN;
        }

        public Class<EnumFacing> getType() {
            return EnumFacing.class;
        }

        public String valueToString(EnumFacing value) {
            return value.toString().toLowerCase();
        }
    };

    public CableBlock() {
        super("cable");
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            boolean matchup = world.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
            boolean matchdown = world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
            IExtendedBlockState theState = (IExtendedBlockState)state;
            theState = matchup && matchdown ? theState.withProperty(STATE, (Object)CableState.MIDDLE) : (matchup ? theState.withProperty(STATE, (Object)CableState.BOTTOM) : theState.withProperty(STATE, (Object)CableState.TOP));
            IBlockState east = world.func_180495_p(pos.func_177974_f());
            IBlockState west = world.func_180495_p(pos.func_177976_e());
            IBlockState north = world.func_180495_p(pos.func_177978_c());
            IBlockState south = world.func_180495_p(pos.func_177968_d());
            Block toCheck = BlockRegistry.CATWALK;
            if (east.func_177230_c() == toCheck) {
                theState = theState.withProperty(FACING, (Object)EnumFacing.EAST);
                theState = theState.withProperty(CONNECTED, (Object)true);
            } else if (west.func_177230_c() == toCheck) {
                theState = theState.withProperty(FACING, (Object)EnumFacing.WEST);
                theState = theState.withProperty(CONNECTED, (Object)true);
            } else if (north.func_177230_c() == toCheck) {
                theState = theState.withProperty(FACING, (Object)EnumFacing.NORTH);
                theState = theState.withProperty(CONNECTED, (Object)true);
            } else if (south.func_177230_c() == toCheck) {
                theState = theState.withProperty(FACING, (Object)EnumFacing.SOUTH);
                theState = theState.withProperty(CONNECTED, (Object)true);
            } else {
                theState = theState.withProperty(CONNECTED, (Object)false);
            }
            return theState;
        }
        return state;
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        CableBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)worldIn, pos));
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState estate = this.getExtendedState(state, source, pos);
        if (estate instanceof IExtendedBlockState) {
            IExtendedBlockState estater = (IExtendedBlockState)estate;
            if (((Boolean)estater.getValue(CONNECTED)).booleanValue()) {
                switch ((EnumFacing)estater.getValue(FACING)) {
                    case NORTH: {
                        return CABLE_BOX.func_111270_a(CLIP_BOX_NORTH_SOUTH);
                    }
                    case SOUTH: {
                        return CABLE_BOX.func_111270_a(CLIP_BOX_NORTH_SOUTH).func_72317_d(0.0, 0.0, 0.4);
                    }
                    case EAST: {
                        return CABLE_BOX.func_111270_a(CLIP_BOX_EAST_WEST).func_72317_d(0.4, 0.0, 0.0);
                    }
                    case WEST: {
                        return CABLE_BOX.func_111270_a(CLIP_BOX_EAST_WEST);
                    }
                }
            } else {
                return CABLE_BOX;
            }
        }
        return CABLE_BOX;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{CONNECTED}).add(new IUnlistedProperty[]{FACING}).add(new IUnlistedProperty[]{STATE}).build();
    }

    public static enum CableState implements IStringSerializable
    {
        TOP,
        MIDDLE,
        BOTTOM;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

