/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.util;

import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import vazkii.arl.interf.IDropInItem;
import vazkii.arl.network.NetworkHandler;
import vazkii.arl.network.message.MessageDropIn;
import vazkii.arl.util.RenderHelper;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="autoreglib")
public final class DropInHandler {
    public static void register() {
        CapabilityManager.INSTANCE.register(IDropInItem.class, (Capability.IStorage)CapabilityFactory.INSTANCE, (Callable)CapabilityFactory.INSTANCE);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        if (gui instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)gui;
            ItemStack held = mc.field_71439_g.field_71071_by.func_70445_o();
            if (!held.func_190926_b()) {
                Slot under = container.getSlotUnderMouse();
                for (Slot s : container.field_147002_h.field_75151_b) {
                    int y;
                    int x;
                    ItemStack stack = s.func_75211_c();
                    IDropInItem dropin = DropInHandler.getDropInHandler(stack);
                    if (dropin == null) continue;
                    if (s == under) {
                        x = event.getMouseX();
                        y = event.getMouseY();
                        RenderHelper.renderTooltip(x, y, dropin.getDropInTooltip(stack));
                        continue;
                    }
                    x = container.getGuiLeft() + s.field_75223_e;
                    y = container.getGuiTop() + s.field_75221_f;
                    GlStateManager.func_179097_i();
                    mc.field_71466_p.func_175063_a("+", (float)(x + 10), (float)(y + 8), 0xFFFF00);
                    GlStateManager.func_179126_j();
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRightClick(GuiScreenEvent.MouseInputEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        if (gui instanceof GuiContainer && Mouse.getEventButton() == 1) {
            ItemStack stack;
            IDropInItem dropin;
            GuiContainer container = (GuiContainer)gui;
            Slot under = container.getSlotUnderMouse();
            ItemStack held = mc.field_71439_g.field_71071_by.func_70445_o();
            if (under != null && !held.func_190926_b() && (dropin = DropInHandler.getDropInHandler(stack = under.func_75211_c())) != null) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageDropIn(under.field_75222_d, held));
                event.setCanceled(true);
            }
        }
    }

    public static void executeDropIn(EntityPlayer player, int slot, ItemStack stack) {
        Container container = player.field_71070_bA;
        Slot slotObj = (Slot)container.field_75151_b.get(slot);
        ItemStack target = slotObj.func_75211_c();
        IDropInItem dropin = DropInHandler.getDropInHandler(target);
        if (dropin != null && dropin.canDropItemIn(player, target, stack)) {
            ItemStack held = player.field_71071_by.func_70445_o();
            if (player.func_184812_l_() && !stack.func_190926_b()) {
                held = stack;
            }
            ItemStack result = dropin.dropItemIn(player, target, held);
            slotObj.func_75215_d(result);
            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
            player.field_71071_by.func_70296_d();
        }
    }

    public static IDropInItem getDropInHandler(ItemStack stack) {
        IDropInItem item;
        if (stack.hasCapability(IDropInItem.DROP_IN_CAPABILITY, null) && (item = (IDropInItem)stack.getCapability(IDropInItem.DROP_IN_CAPABILITY, null)) != null) {
            return item;
        }
        if (stack.func_77973_b() instanceof IDropInItem) {
            return (IDropInItem)stack.func_77973_b();
        }
        return null;
    }

    private static class CapabilityFactory
    implements Capability.IStorage<IDropInItem>,
    Callable<IDropInItem> {
        private static CapabilityFactory INSTANCE = new CapabilityFactory();

        private CapabilityFactory() {
        }

        public NBTBase writeNBT(Capability<IDropInItem> capability, IDropInItem instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<IDropInItem> capability, IDropInItem instance, EnumFacing side, NBTBase nbt) {
        }

        @Override
        public IDropInItem call() {
            return new DefaultImpl();
        }

        private static class DefaultImpl
        implements IDropInItem {
            private DefaultImpl() {
            }

            @Override
            public boolean canDropItemIn(EntityPlayer player, ItemStack stack, ItemStack incoming) {
                return false;
            }

            @Override
            public ItemStack dropItemIn(EntityPlayer player, ItemStack stack, ItemStack incoming) {
                return incoming;
            }
        }
    }
}

