/*
 * Decompiled with CFR 0.152.
 */
package dongle12.miscrails.rails.standard_rails;

import dongle12.miscrails.rails.standard_rails.StandardRail;
import dongle12.miscrails.util.ConfigHandler;
import dongle12.miscrails.util.RailUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IntersectionRail
extends StandardRail {
    public IntersectionRail() {
        super(false, "intersection_rail");
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, BlockPos pos) {
        float retSpeed = 0.4f;
        for (EnumFacing side : EnumFacing.field_176754_o) {
            BlockPos nextPos = pos.func_177972_a(side);
            boolean foundRail = RailUtil.FoundRail(world, nextPos);
            if (!foundRail) {
                if (RailUtil.FoundRail(world, nextPos.func_177977_b())) {
                    foundRail = true;
                    nextPos = nextPos.func_177984_a();
                } else if (RailUtil.FoundRail(world, nextPos.func_177977_b())) {
                    foundRail = true;
                    nextPos = nextPos.func_177977_b();
                }
            }
            if (!foundRail) continue;
            BlockRailBase.EnumRailDirection dir = RailUtil.RailDirection(world, cart, pos);
            BlockRailBase.EnumRailDirection dirNext = RailUtil.RailDirection(world, cart, nextPos);
            retSpeed = dir != null && dir.func_177018_c() || dirNext != null && dirNext.func_177018_c() ? 0.4f : super.getRailMaxSpeed(world, cart, pos) * ConfigHandler.SPEED_RAIL_MULTIPLIER;
        }
        return retSpeed;
    }

    public BlockRailBase.EnumRailDirection getRailDirection(IBlockAccess world, BlockPos pos, IBlockState state, @Nullable EntityMinecart cart) {
        if (cart != null) {
            if (Math.abs(cart.field_70159_w) > 0.0) {
                return BlockRailBase.EnumRailDirection.EAST_WEST;
            }
            if (Math.abs(cart.field_70179_y) > 0.0) {
                return BlockRailBase.EnumRailDirection.NORTH_SOUTH;
            }
        } else {
            return (BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l());
        }
        return (BlockRailBase.EnumRailDirection)state.func_177229_b(this.func_176560_l());
    }

    public ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public boolean canMakeSlopes(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isFlexibleRail(IBlockAccess world, BlockPos pos) {
        return false;
    }
}

