/*
 * Decompiled with CFR 0.152.
 */
package dongle12.miscrails.rails.special_rails;

import dongle12.miscrails.MiscRails;
import dongle12.miscrails.util.ConfigHandler;
import dongle12.miscrails.util.RailUtil;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DetectionRail
extends BlockRailDetector {
    final ItemBlock itemBlock;
    private static final AxisAlignedBB FLAT_BOUNDING = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.45f, 1.0);
    private static final AxisAlignedBB ASCENDING_BOUNDING = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.85f, 1.0);
    private static final AxisAlignedBB COLLISION_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)-0.15f, 1.0);

    public DetectionRail() {
        this.func_149663_c("miscrails.detection_rail");
        this.setRegistryName(new ResourceLocation("miscrails", "detection_rail"));
        this.itemBlock = new ItemBlock((Block)this);
        this.itemBlock.setRegistryName(new ResourceLocation("miscrails", "detection_rail"));
        this.itemBlock.func_77655_b("miscrails.detection_rail");
        this.func_149647_a(MiscRails.miscRailsTab);
        try {
            Field blockMat = ReflectionHelper.findField(Block.class, (String[])new String[]{"blockMaterial", "field_149764_J"});
            blockMat.setAccessible(true);
            ReflectionHelper.setPrivateValue(Block.class, (Object)((Object)this), (Object)Material.field_151575_d, (int)18);
        }
        catch (Exception e) {
            System.out.println("ERROR");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public float getRailMaxSpeed(World world, EntityMinecart cart, BlockPos pos) {
        float retSpeed = 0.4f;
        for (EnumFacing side : EnumFacing.field_176754_o) {
            BlockPos nextPos = pos.func_177972_a(side);
            boolean foundRail = RailUtil.FoundRail(world, nextPos);
            if (!foundRail) {
                if (RailUtil.FoundRail(world, nextPos.func_177977_b())) {
                    foundRail = true;
                    nextPos = nextPos.func_177984_a();
                } else if (RailUtil.FoundRail(world, nextPos.func_177977_b())) {
                    foundRail = true;
                    nextPos = nextPos.func_177977_b();
                }
            }
            if (!foundRail) continue;
            BlockRailBase.EnumRailDirection dir = RailUtil.RailDirection(world, cart, pos);
            BlockRailBase.EnumRailDirection dirNext = RailUtil.RailDirection(world, cart, nextPos);
            retSpeed = dir != null && dir.func_177018_c() || dirNext != null && dirNext.func_177018_c() ? 0.4f : super.getRailMaxSpeed(world, cart, pos) * ConfigHandler.SPEED_RAIL_MULTIPLIER;
        }
        return retSpeed;
    }

    public ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        boolean blockFound;
        boolean railFound = RailUtil.FoundRail(world, pos.func_177974_f()) || RailUtil.FoundRail(world, pos.func_177976_e()) || RailUtil.FoundRail(world, pos.func_177978_c()) || RailUtil.FoundRail(world, pos.func_177968_d());
        boolean bl = blockFound = RailUtil.IsBlock(world, pos.func_177974_f()) || RailUtil.IsBlock(world, pos.func_177976_e()) || RailUtil.IsBlock(world, pos.func_177978_c()) || RailUtil.IsBlock(world, pos.func_177968_d());
        if (RailUtil.FoundRail(world, pos.func_177977_b())) {
            return false;
        }
        if (blockFound || railFound) {
            return true;
        }
        return world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = this.getRailDirection((IBlockAccess)worldIn, pos, worldIn.func_180495_p(pos), null);
            boolean flag = false;
            if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.ASCENDING_EAST && !worldIn.func_180495_p(pos.func_177974_f()).isSideSolid((IBlockAccess)worldIn, pos.func_177974_f(), EnumFacing.UP)) {
                flag = true;
            } else if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.ASCENDING_WEST && !worldIn.func_180495_p(pos.func_177976_e()).isSideSolid((IBlockAccess)worldIn, pos.func_177976_e(), EnumFacing.UP)) {
                flag = true;
            } else if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.ASCENDING_NORTH && !worldIn.func_180495_p(pos.func_177978_c()).isSideSolid((IBlockAccess)worldIn, pos.func_177978_c(), EnumFacing.UP)) {
                flag = true;
            } else if (blockrailbase$enumraildirection == BlockRailBase.EnumRailDirection.ASCENDING_SOUTH && !worldIn.func_180495_p(pos.func_177968_d()).isSideSolid((IBlockAccess)worldIn, pos.func_177968_d(), EnumFacing.UP)) {
                flag = true;
            } else {
                this.func_189541_b(state, worldIn, pos, blockIn);
            }
        }
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        BlockRailBase.EnumRailDirection blockrailbase$enumraildirection = state.func_177230_c() == this ? this.getRailDirection(source, pos, state, null) : null;
        return blockrailbase$enumraildirection != null && blockrailbase$enumraildirection.func_177018_c() ? ASCENDING_BOUNDING : field_185590_a;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_BOX;
    }
}

