/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.api.IWind;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.smoke.SmokeParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Renderer {
    private static final FloatBounds dyBounds = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.6f));

    public static void renderSmoke(World world, IWind wind, Smoke smoke, BlockPos pos, float factor) {
        world.field_72984_F.func_76320_a("renderSmoke");
        int smokeAmount = Math.round(smoke.getAmount() * factor);
        FloatBounds dxzBounds = FloatBounds.from((Float)Float.valueOf(0.125f), (Float)Float.valueOf(0.875f)).reduce(Float.valueOf(smoke.getScale() / 10.0f));
        for (int i = 0; i < smokeAmount; ++i) {
            double dx = dxzBounds.randomBetween().floatValue();
            double dy = dyBounds.randomBetween().floatValue();
            double dz = dxzBounds.randomBetween().floatValue();
            Vect3d smokePos = Vect3d.from((BlockPos)pos).move(dx, dy, dz);
            SmokeParticle smokeParticle = new SmokeParticle(world, wind, smokePos, smoke.getIntencity(), smoke.getScale(), smoke.pickColor());
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smokeParticle);
        }
        world.field_72984_F.func_76319_b();
    }
}

