/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.Args;
import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.ForgeEmitter;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Emitter
extends ForgeEmitter {
    private final ColorARGB color;
    private final Smoke smoke;
    private final boolean canEmitAside;
    private final boolean emitWithoutChimney;

    public Emitter() {
        this(Smoke.getNone(), Smoke.defaultColor, false, false);
    }

    public Emitter(Smoke smoke, ColorARGB color, boolean canEmitAside, boolean emitWithoutChimney) {
        this(null, UnitId.EMPTY, smoke, color, canEmitAside, emitWithoutChimney, "", "", false, new String[0]);
    }

    public Emitter(@Nullable UnitConfig config, UnitId relatedBlockId, Smoke smoke, ColorARGB color, boolean canEmitAside, boolean emitWithoutChimney, String activeStateTag, String identityTag, boolean useDroppedItemMeta, String ... relatedBlocks) {
        super(config, relatedBlockId, KeyValuePair.from((String)identityTag), false, activeStateTag, useDroppedItemMeta, relatedBlocks);
        String category = this.getClassCategory();
        this.color = ForgeConfig.getColorARGB((ForgeConfig)config, (String)category, (String)"color", (ColorARGB)color, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb) which will be applied to the smoke.\nThe alpha channel of this color (aa) determines probability of applying (ff - always, 7f - 1/2, 00 - never).\n");
        this.smoke = new Smoke(config, smoke.getAmount(), smoke.getIntencity(), smoke.getScale(), this.getColor());
        this.canEmitAside = ForgeConfig.getBool((ForgeConfig)config, (String)category, (String)"canEmitAside", (boolean)canEmitAside, (String)"If true, the smoke will be transferred to the chimneys directly connected from aside.");
        this.emitWithoutChimney = ForgeConfig.getBool((ForgeConfig)config, (String)category, (String)"emitWithoutChimney", (boolean)emitWithoutChimney, (String)"If true, the smoke particles will be generated even without connected chimney.");
        this.saveConfig();
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public static Emitter getFromNBT(NBTTagCompound compound) {
        NBTTagCompound tag = compound.func_74775_l(Emitter.class.getSimpleName());
        String stringId = tag.func_74779_i(Tags.RELATED_BLOCK_ID.name());
        UnitId relatedBlockId = UnitId.EMPTY.toString().equals(stringId) ? UnitId.EMPTY : UnitId.from((String)stringId);
        Smoke smoke = Smoke.getFromNBT(tag);
        int intARGB = tag.func_74762_e(Tags.COLOR.name());
        boolean canEmitAside = tag.func_74767_n(Tags.CAN_EMIT_ASIDE.name());
        boolean emitWithoutChimney = tag.func_74767_n(Tags.EMIT_WITHOUT_CHIMNEY.name());
        boolean useDroppedItemMeta = tag.func_74767_n(Tags.USE_DROPPED_ITEM_META.name());
        String nbtControlKey = tag.func_74779_i(Tags.NBT_CONTROL_KEY.name());
        String identityTag = tag.func_74779_i(Tags.IDENTITY_TAG.name());
        return new Emitter(null, relatedBlockId, smoke, ColorARGB.from((int)intARGB), canEmitAside, emitWithoutChimney, nbtControlKey, identityTag, useDroppedItemMeta, new String[0]);
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a(Tags.RELATED_BLOCK_ID.name(), this.getRelatedId().toString());
        this.getSmoke().writeToNBT(tag);
        tag.func_74768_a(Tags.COLOR.name(), this.getColor().getARGB());
        tag.func_74757_a(Tags.CAN_EMIT_ASIDE.name(), this.canEmitAside());
        tag.func_74757_a(Tags.EMIT_WITHOUT_CHIMNEY.name(), this.emitWithoutChimney());
        tag.func_74757_a(Tags.USE_DROPPED_ITEM_META.name(), this.useDroppedItemMeta());
        tag.func_74778_a(Tags.NBT_CONTROL_KEY.name(), this.getActiveStateTag());
        tag.func_74778_a(Tags.IDENTITY_TAG.name(), this.getIdentityTag().toString());
        compound.func_74782_a(((Object)((Object)this)).getClass().getSimpleName(), (NBTBase)tag);
    }

    public String getClassCategory() {
        return IHaveConfig.getClassCategory(Emitter.class);
    }

    public Smoke getSmoke(World world, BlockPos pos, boolean useTopEmitter, boolean useSideEmitter) {
        if ((useTopEmitter || useSideEmitter && this.canEmitAside()) && this.isActive(world, pos)) {
            return new Smoke().combine(this.smoke);
        }
        return new Smoke();
    }

    public String toString() {
        return Emitter.class.getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"canEmitAside", (Object)this.canEmitAside()), Args.get((String)"activeStateTag", (Object)this.getActiveStateTag()), this.getSmoke()}) + Args.extend((Object)super.toString());
    }

    public boolean canEmitAside() {
        return this.canEmitAside;
    }

    public Smoke getSmoke() {
        return this.smoke;
    }

    public boolean emitWithoutChimney() {
        return this.emitWithoutChimney;
    }

    public boolean isEntity() {
        return false;
    }

    private static enum Tags {
        RELATED_BLOCK_ID,
        COLOR,
        CAN_EMIT_ASIDE,
        EMIT_WITHOUT_CHIMNEY,
        USE_DROPPED_ITEM_META,
        NBT_CONTROL_KEY,
        IDENTITY_TAG;

    }
}

