/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.init;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitsInitWithEnum;
import com.endertech.minecraft.mods.adchimneys.Main;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class Containers
extends UnitsInitWithEnum<Container, BuiltInContainers> {
    public Containers(ForgeMod mod) {
        super(mod, BuiltInContainers.class);
    }

    public Container createCustomUnitFrom(UnitConfig config, String name) {
        return new Container(this.getMod(), config, name, UnitId.from((String)name), Smoke.defaultColor, 8);
    }

    public Container createDefaultUnitFrom(UnitConfig config, BuiltInContainers e) {
        UnitId id = e.relatedBlockId.isEmpty() ? UnitId.from((Enum)e, (boolean)false) : UnitId.from((String)e.relatedBlockId);
        return new Container(this.getMod(), config, e.func_176610_l(), id, e.color, e.stackSize);
    }

    @SubscribeEvent
    public static void remapMissingItems(RegistryEvent.MissingMappings<Item> event) {
        Map<String, Container> chimneyMappings = Containers.getChimneyMappings();
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            String oldName = mapping.key.func_110623_a().toLowerCase(Locale.ROOT);
            Container chimney = chimneyMappings.get(oldName);
            if (chimney == null) continue;
            mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)chimney));
        }
    }

    @SubscribeEvent
    public static void remapMissingBlocks(RegistryEvent.MissingMappings<Block> event) {
        Map<String, Container> chimneyMappings = Containers.getChimneyMappings();
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            String oldName = mapping.key.func_110623_a().toLowerCase(Locale.ROOT);
            Container chimney = chimneyMappings.get(oldName);
            if (chimney == null) continue;
            mapping.remap((IForgeRegistryEntry)chimney);
        }
    }

    private static Map<String, Container> getChimneyMappings() {
        String chimneyStr = "chimney";
        HashMap<String, Container> mappings = new HashMap<String, Container>();
        for (Container chimney : Main.getChimneys().getAll()) {
            UnitId relatedUnitId = chimney.getRelatedId();
            mappings.put("chimney" + relatedUnitId.getRegName().toLowerCase(Locale.ROOT), chimney);
            mappings.put("chimney" + relatedUnitId.getDictName().toLowerCase(Locale.ROOT), chimney);
        }
        return mappings;
    }

    public static enum BuiltInContainers implements IForgeEnum
    {
        bedrock(291660403, 16),
        bone_block_side("bone_block", 296724378, 16),
        brick("brick_block", 293159732, 8),
        clay(581282233, 16),
        coal_block(0x33000000, 8),
        coarse_dirt("dirt:1", 861486634, 8),
        cobblestone("cobblestone:0", 0x11666666, 8),
        cobblestone_mossy("mossy_cobblestone", 0x11449144, 8),
        concrete_black("concrete:15", 285805328, 16),
        concrete_blue("concrete:11", 288042380, 16),
        concrete_brown("concrete:12", 291387934, 16),
        concrete_cyan("concrete:9", 286619270, 16),
        concrete_gray("concrete:7", 288766269, 16),
        concrete_green("concrete:13", 289954083, 16),
        concrete_light_blue("concrete:3", 287541188, 16),
        concrete_lime("concrete:5", 291415834, 16),
        concrete_magenta("concrete:2", 296169629, 16),
        concrete_orange("concrete:1", 299589120, 16),
        concrete_pink("concrete:6", 299066510, 16),
        concrete_purple("concrete:10", 291774619, 16),
        concrete_red("concrete:14", 294396193, 16),
        concrete_silver("concrete:8", 0x117B7B71, 16),
        concrete_white("concrete:0", 298570194, 16),
        concrete_yellow("concrete:4", 300657429, 16),
        diamond_block(292084951, 24),
        dirt(1717519150, 4),
        emerald_block(285278003, 24),
        end_bricks(0x11993399, 8),
        end_stone(0x22993399, 8),
        glass(0, 16),
        glass_black("stained_glass:15", 285805328, 16),
        glass_blue("stained_glass:11", 288042380, 16),
        glass_brown("stained_glass:12", 291387934, 16),
        glass_cyan("stained_glass:9", 286619270, 16),
        glass_gray("stained_glass:7", 288766269, 16),
        glass_green("stained_glass:13", 289954083, 16),
        glass_light_blue("stained_glass:3", 287541188, 16),
        glass_lime("stained_glass:5", 291415834, 16),
        glass_magenta("stained_glass:2", 296169629, 16),
        glass_orange("stained_glass:1", 299589120, 16),
        glass_pink("stained_glass:6", 299066510, 16),
        glass_purple("stained_glass:10", 291774619, 16),
        glass_red("stained_glass:14", 294396193, 16),
        glass_silver("stained_glass:8", 0x117B7B71, 16),
        glass_white("stained_glass:0", 298570194, 16),
        glass_yellow("stained_glass:4", 300657429, 16),
        glazed_terracotta_black("black_glazed_terracotta", 285805328, 16),
        glazed_terracotta_blue("blue_glazed_terracotta", 288042380, 16),
        glazed_terracotta_brown("brown_glazed_terracotta", 291387934, 16),
        glazed_terracotta_cyan("cyan_glazed_terracotta", 286619270, 16),
        glazed_terracotta_gray("gray_glazed_terracotta", 288766269, 16),
        glazed_terracotta_green("green_glazed_terracotta", 289954083, 16),
        glazed_terracotta_light_blue("light_blue_glazed_terracotta", 287541188, 16),
        glazed_terracotta_lime("lime_glazed_terracotta", 291415834, 16),
        glazed_terracotta_magenta("magenta_glazed_terracotta", 296169629, 16),
        glazed_terracotta_orange("orange_glazed_terracotta", 299589120, 16),
        glazed_terracotta_pink("pink_glazed_terracotta", 299066510, 16),
        glazed_terracotta_purple("purple_glazed_terracotta", 291774619, 16),
        glazed_terracotta_red("red_glazed_terracotta", 294396193, 16),
        glazed_terracotta_silver("silver_glazed_terracotta", 0x117B7B71, 16),
        glazed_terracotta_white("white_glazed_terracotta", 298570194, 16),
        glazed_terracotta_yellow("yellow_glazed_terracotta", 300657429, 16),
        glowstone(301972574, 8),
        gold_block(0x11FFFF00, 16),
        hardened_clay(294869312, 16),
        hardened_clay_stained_black("stained_hardened_clay:15", 285805328, 16),
        hardened_clay_stained_blue("stained_hardened_clay:11", 288042380, 16),
        hardened_clay_stained_brown("stained_hardened_clay:12", 291387934, 16),
        hardened_clay_stained_cyan("stained_hardened_clay:9", 286619270, 16),
        hardened_clay_stained_gray("stained_hardened_clay:7", 288766269, 16),
        hardened_clay_stained_green("stained_hardened_clay:13", 289954083, 16),
        hardened_clay_stained_light_blue("stained_hardened_clay:3", 287541188, 16),
        hardened_clay_stained_lime("stained_hardened_clay:5", 291415834, 16),
        hardened_clay_stained_magenta("stained_hardened_clay:2", 296169629, 16),
        hardened_clay_stained_orange("stained_hardened_clay:1", 299589120, 16),
        hardened_clay_stained_pink("stained_hardened_clay:6", 299066510, 16),
        hardened_clay_stained_purple("stained_hardened_clay:10", 291774619, 16),
        hardened_clay_stained_red("stained_hardened_clay:14", 294396193, 16),
        hardened_clay_stained_silver("stained_hardened_clay:8", 0x117B7B71, 16),
        hardened_clay_stained_white("stained_hardened_clay:0", 298570194, 16),
        hardened_clay_stained_yellow("stained_hardened_clay:4", 300657429, 16),
        iron_block(0x11999999, 16),
        lapis_block(0x330000FF, 8),
        magma(870413082, 8),
        nether_brick(0x11330000, 8),
        nether_wart_block(576128005, 8),
        netherrack(0x22993333, 8),
        obsidian(291910553, 16),
        prismarine_rough("prismarine", 293520573, 8),
        prismarine_bricks("prismarine:1", 292467365, 8),
        prismarine_dark("prismarine:2", 288970574, 8),
        purpur_block(295990692, 8),
        quartz_block_chiseled("quartz_block:1", 300476128, 16),
        quartz_block_lines("quartz_block:2", 300080853, 16),
        quartz_block_side("quartz_block", 300476128, 16),
        red_nether_brick(288752131, 8),
        red_sandstone_carved("red_sandstone:1", 580800539, 8),
        red_sandstone_normal("red_sandstone", 580800539, 8),
        red_sandstone_smooth("red_sandstone:2", 580800539, 8),
        sandstone_carved("sandstone:1", 0x22CCCC66, 8),
        sandstone_normal("sandstone", 0x22CCCC66, 8),
        sandstone_smooth("sandstone:2", 0x22CCCC66, 8),
        sea_lantern(580763316, 16),
        soul_sand(577722185, 8),
        stone(0x11666666, 8),
        stone_andesite("stone:5", 293634182, 8),
        stone_andesite_smooth("stone:6", 293634182, 8),
        stone_diorite("stone:3", 296726450, 8),
        stone_diorite_smooth("stone:4", 296726450, 8),
        stone_granite("stone:1", 296318820, 8),
        stone_granite_smooth("stone:2", 296318820, 8),
        stonebrick(0x11666666, 8),
        stonebrick_mossy("stonebrick:1", 289360169, 8),
        stonebrick_cracked("stonebrick:2", 0x11666666, 8),
        limestone_brick_small("atume:limestone_brick_small", 297377917, 8),
        limestone_brick_large("atume:limestone_brick_large", 297377917, 8),
        mud_brick_block("biomesoplenty:mud_brick_block", 293625417, 8),
        porcelain_brick("ceramics:clay_hard", 295083421, 8),
        dark_brick("ceramics:clay_hard:1", 290529556, 8),
        marine_brick("ceramics:clay_hard:2", 292068275, 8),
        golden_brick("ceramics:clay_hard:3", 301188980, 8),
        dragon_brick("ceramics:clay_hard:4", 300777210, 8),
        lava_brick("ceramics:clay_hard:5", 299066391, 8),
        rainbow_brick("ceramics:clay_hard:6", 300345833, 8),
        monochrome_brick("ceramics:clay_hard:7", 0x11707070, 8),
        cobblestone_andesite("divergentunderground:andesite_cobblestone", 293239937, 8),
        cobblestone_diorite("divergentunderground:diorite_cobblestone", 0x11F4F4F4, 8),
        cobblestone_granite("divergentunderground:granite_cobblestone", 294674768, 8),
        cobblestone_basalt("divergentunderground:quark_basalt_cobblestone", 0x11363636, 8),
        cobblestone_limestone("divergentunderground:quark_limestone_cobblestone", 297447312, 8),
        cobblestone_marble("divergentunderground:quark_marble_cobblestone", 297120947, 8),
        cokebrick("immersiveengineering:stone_decoration", 0x11575757, 8),
        blastbrick("immersiveengineering:stone_decoration:1", 292304422, 8),
        charred_nether_brick("quark:charred_nether_bricks", 0x11202020, 8),
        elder_prismarine_brick("quark:elder_prismarine:1", 298101918, 8),
        magma_brick("quark:magma_bricks", 300311568, 8),
        polished_netherrack_brick("quark:polished_netherrack:1", 292954658, 8),
        red_sandstone_brick("quark:sandstone_new:3", 297033253, 8),
        sandstone_brick("quark:sandstone_new:1", 299685024, 8),
        sandy_brick("quark:sandy_bricks", 295139146, 8),
        snow_brick("quark:snow_bricks", 0x11EEFFFF, 8),
        soul_sandstone_brick("quark:sandstone_new:5", 288956177, 8),
        stone_andesite_brick("quark:world_stone_bricks:2", 294028939, 8),
        stone_basalt_brick("quark:world_stone_bricks:3", 0x11171717, 8),
        stone_diorite_brick("quark:world_stone_bricks:1", 296726450, 8),
        stone_granite_brick("quark:world_stone_bricks:0", 295068755, 8),
        stone_limestone_brick("quark:world_stone_bricks:5", 295539838, 8),
        stone_marble_brick("quark:world_stone_bricks:4", 298765772, 8),
        cobblestone_fire("quark:biome_cobblestone:0", 297551653, 8),
        cobblestone_icy("quark:biome_cobblestone:1", 291474352, 8),
        iron_plate("quark:iron_plate:0", 0x115D5D5D, 8),
        iron_plate_rusted("quark:iron_plate:1", 292378182, 8),
        stone_marble("quark:marble", 298831565, 8),
        stone_marble_smooth("quark:marble:1", 298831565, 8),
        brownstone_brick("tconstruct:brownstone:3", 296330108, 8),
        brownstone_brick_small("tconstruct:brownstone:10", 296330108, 8),
        dried_clay_brick("tconstruct:dried_clay:1", 294287707, 8),
        mud_brick("tconstruct:deco_ground", 294810191, 8),
        seared_brick("tconstruct:seared:3", 288172844, 8),
        seared_brick_fancy("tconstruct:seared:5", 288172844, 8),
        seared_brick_small("tconstruct:seared:10", 288172844, 8),
        seared_brick_triangle("tconstruct:seared:9", 288172844, 8);

        public final String relatedBlockId;
        public final ColorARGB color;
        public final int stackSize;

        private BuiltInContainers(int argbColor, int stackSize) {
            this("", argbColor, stackSize);
        }

        private BuiltInContainers(String relatedBlockId, int argbColor, int stackSize) {
            this.relatedBlockId = relatedBlockId;
            this.color = ColorARGB.from((int)argbColor);
            this.stackSize = stackSize;
        }

        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }
    }
}

