/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.api.IPollutant;
import com.endertech.minecraft.forge.data.ForgeEnergyStorage;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adchimneys.Main;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEntityPump
extends TileEntity
implements ITickable {
    public static boolean invertedRedstoneSignal = false;
    public static boolean requiresForgeEnergy = false;
    public static int energyCapacity = 10000;
    public static int energyUse = 50;
    protected final GameTime updateInterval = GameTime.second();
    protected final ForgeEnergyStorage energyStorage = ForgeEnergyStorage.of((int)energyCapacity);

    protected boolean isEmitterConnected() {
        Emitter emitter;
        BlockPos checkPos = this.func_174877_v().func_177984_a();
        if (ForgeWorld.SmokeContainers.isChimney((World)this.field_145850_b, (BlockPos)checkPos)) {
            checkPos = ForgeWorld.SmokeContainers.getTopmostChimney((World)this.field_145850_b, (BlockPos)checkPos);
            checkPos = checkPos.func_177984_a();
        }
        return (emitter = Main.getEmitters().findBy(this.field_145850_b, checkPos)) != null;
    }

    public boolean isActive() {
        boolean powered = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (invertedRedstoneSignal) {
            boolean bl = powered = !powered;
        }
        if (requiresForgeEnergy && this.energyStorage.extractEnergy(energyUse, true) < energyUse) {
            powered = false;
        }
        return powered;
    }

    public void func_73660_a() {
        if (ForgeWorld.isServerSide((World)this.field_145850_b) && this.updateInterval.pastIn(this.field_145850_b) && this.isActive()) {
            BlockPos outletPos;
            if (requiresForgeEnergy) {
                this.energyStorage.extractEnergy(energyUse, false);
            }
            if (!(!ForgeWorld.isAirBlock((World)this.field_145850_b, (BlockPos)(outletPos = this.field_174879_c.func_177984_a())) && this.field_145850_b.isSideSolid(outletPos, EnumFacing.DOWN) || this.isEmitterConnected())) {
                List vents = ForgeWorld.SmokeContainers.getVentsAround((World)this.field_145850_b, (BlockPos)this.field_174879_c);
                vents.add(this.field_174879_c);
                VentPipe.build(this.field_145850_b, vents, outletPos);
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (requiresForgeEnergy && capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (requiresForgeEnergy && capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (requiresForgeEnergy) {
            this.energyStorage.deserializeNBT(compound.func_74775_l("ForgeEnergy"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (requiresForgeEnergy) {
            compound.func_74782_a("ForgeEnergy", (NBTBase)this.energyStorage.serializeNBT());
        }
        return super.func_189515_b(compound);
    }

    private static class VentPipe
    extends WorldSearch.BlockChain {
        private final BlockPos outletPos;

        protected VentPipe(World world, BlockPos startPos, BlockPos outletPos) {
            super(world, startPos, ForgeWorld.SmokeContainers.maxVentPipeLength);
            this.outletPos = outletPos;
        }

        public static void build(World world, List<BlockPos> startPositions, BlockPos outletPos) {
            ArrayList<VentPipe> builtPipes = new ArrayList<VentPipe>();
            block0: for (BlockPos pos : startPositions) {
                for (VentPipe pipe : builtPipes) {
                    if (!pipe.getChain().contains(pos)) continue;
                    continue block0;
                }
                VentPipe pipe = new VentPipe(world, pos, outletPos);
                pipe.build();
                builtPipes.add(pipe);
            }
        }

        protected boolean isValidPath(BlockPos pos) {
            return ForgeWorld.SmokeContainers.isVent((World)this.world, (BlockPos)pos);
        }

        protected boolean isValidBlock(BlockPos pos) {
            return this.isValidPath(pos) || ForgeWorld.SmokeContainers.isPump((World)this.world, (BlockPos)pos);
        }

        protected boolean onValidFound(BlockPos foundPos) {
            block0: for (EnumFacing facing : ForgeWorld.Direction.getShuffledHorizontals()) {
                for (int dist = 1; dist <= ForgeWorld.SmokeContainers.ventInhaleDistance; ++dist) {
                    IPollutant pollutant;
                    BlockPos pos = foundPos.func_177967_a(facing, dist);
                    IBlockState state = this.world.func_180495_p(pos);
                    if (ForgeWorld.isAirBlock((IBlockState)state)) continue;
                    if (state.func_177230_c() instanceof IPollutant && (pollutant = (IPollutant)state.func_177230_c()).getPollutantType() == IPollutant.Type.AIR) {
                        if (this.pumpOutletWith(pollutant, pos, state)) continue block0;
                        return false;
                    }
                    if (state.isSideSolid((IBlockAccess)this.world, pos, facing) || state.isSideSolid((IBlockAccess)this.world, pos, facing.func_176734_d())) continue block0;
                }
            }
            return true;
        }

        private boolean pumpOutletWith(IPollutant pollutant, BlockPos pos, IBlockState state) {
            int count = 0;
            if (ForgeWorld.SmokeContainers.isChimney((World)this.world, (BlockPos)this.outletPos) || pollutant.canPassThrough(this.world, this.outletPos, EnumFacing.DOWN, EnumFacing.UP)) {
                int amount = pollutant.getCarriedPollutionAmount(state);
                count += pollutant.pumpEntitiesAt(this.world, this.outletPos, amount);
            }
            if (count > 0) {
                pollutant.spend(this.world, pos, count);
            }
            return count > 0;
        }
    }
}

