/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.ForgeCreativeTab;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.mods.adchimneys.Config;
import com.endertech.minecraft.mods.adchimneys.blocks.Smoker;
import com.endertech.minecraft.mods.adchimneys.blocks.TileEntityPump;
import com.endertech.minecraft.mods.adchimneys.init.Containers;
import com.endertech.minecraft.mods.adchimneys.init.Emitters;
import com.endertech.minecraft.mods.adchimneys.init.Groups;
import com.endertech.minecraft.mods.adchimneys.network.EmitterPosMsg;
import com.endertech.minecraft.mods.adchimneys.network.SmokePosMsg;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="adchimneys", name="Advanced Chimneys", version="1.12.2-3.5.11.0", guiFactory="com.endertech.minecraft.mods.adchimneys.Config$Factory", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:forgeendertech@[1.12.2-4.5.0.0,);after:*")
public class Main
extends ForgeMod {
    public static final String ID = "adchimneys";
    public static final String NAME = "Advanced Chimneys";
    public static final String GUI_FACTORY = "com.endertech.minecraft.mods.adchimneys.Config$Factory";
    public static final ForgeCreativeTab CREATIVE_TAB = new ForgeCreativeTab("adchimneys"){

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_78016_d() {
            if (this.isTimeToChangeIcon(CommonTime.Interval.seconds((double)2.0))) {
                this.setRandomIconFrom(Main.getChimneys().getAll());
            }
            return super.func_78016_d();
        }
    };
    @Mod.Instance(value="adchimneys")
    public static Main instance;
    private static Containers containers;
    private static Emitters emitters;
    private static Smoker smoker;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        this.setConfig(new Config(this.getId(), event));
        Groups.init(this);
        containers = new Containers(this);
        emitters = new Emitters(this);
        smoker = new Smoker(this, new UnitConfig(this.getConfig().getConfigDir(), IForgeUnit.getClassRegName(Smoker.class)));
        this.getRegistrator().registerTileEntity(TileEntityPump.class, "emitter");
        this.getRegistrator().registerNetMessageHandledOnClient(SmokePosMsg.class, SmokePosMsg.Handler.class);
        this.getRegistrator().registerNetMessageHandledOnServer(EmitterPosMsg.class, EmitterPosMsg.Handler.class);
        super.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        super.init(event);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        CREATIVE_TAB.setRandomIconFrom((Collection)Main.getChimneys().getAll());
        super.initClient(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        super.postInit(event);
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public ForgeMod getInstance() {
        return instance;
    }

    public static Smoker getSmoker() {
        return smoker;
    }

    public static Containers getChimneys() {
        return containers;
    }

    public static Emitters getEmitters() {
        return emitters;
    }
}

