/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.misc.IAgriPeripheralMethod;
import com.infinityraider.agricraft.api.v1.util.AgriSideMetaMatrix;
import com.infinityraider.agricraft.tiles.analyzer.TileEntitySeedAnalyzer;
import com.infinityraider.infinitylib.utility.WorldHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Optional;

@SimpleComponent.SkipInjection
@Optional.InterfaceList(value={@Optional.Interface(modid="open_computers", iface="li.cil.oc.api.network.SimpleComponent"), @Optional.Interface(modid="open_computers", iface="li.cil.oc.api.network.ManagedPeripheral")})
public class TileEntityPeripheral
extends TileEntitySeedAnalyzer
implements SimpleComponent,
ManagedPeripheral {
    public static final long NEIGHBOR_CHECK_TIMEOUT = 500L;
    public static final EnumFacing[] VALID_DIRECTIONS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
    public static final int MAX = 60;
    private boolean mayAnalyze = false;
    @Nonnull
    private final AgriSideMetaMatrix connections = new AgriSideMetaMatrix();
    private long last_update = 0L;

    public TileEntityPeripheral() {
        this.refreshConnections();
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return "agricraft_peripheral";
    }

    @Override
    protected void writeRotatableTileNBT(NBTTagCompound tag) {
        super.writeRotatableTileNBT(tag);
        tag.func_74757_a("agri_flag", this.mayAnalyze);
    }

    @Override
    protected void readRotatableTileNBT(NBTTagCompound tag) {
        super.readRotatableTileNBT(tag);
        this.mayAnalyze = tag.func_74764_b("agri_flag") && tag.func_74767_n("agri_flag");
    }

    @Override
    public void func_73660_a() {
        long currentTime;
        if (this.mayAnalyze) {
            if (this.hasSpecimen() && !this.isSpecimenAnalyzed()) {
                super.func_73660_a();
            } else {
                this.reset();
            }
        }
        if ((currentTime = System.currentTimeMillis()) - this.last_update > 500L) {
            this.refreshConnections();
        }
    }

    public final void refreshConnections() {
        for (EnumFacing side : EnumFacing.values()) {
            this.connections.set(side, this.classifyConnection(side));
        }
        this.last_update = System.currentTimeMillis();
    }

    protected byte classifyConnection(@Nonnull EnumFacing side) {
        if (this.isCrop(side)) {
            return 1;
        }
        return 0;
    }

    private boolean isCrop(EnumFacing dir) {
        return WorldHelper.getTile((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(dir), IAgriCrop.class).isPresent();
    }

    public void startAnalyzing() {
        if (!this.mayAnalyze && this.hasSpecimen() && !this.isSpecimenAnalyzed()) {
            this.mayAnalyze = true;
            this.markForUpdate();
        }
    }

    @Override
    public void analyze() {
        super.analyze();
        this.reset();
    }

    private void reset() {
        if (this.mayAnalyze) {
            this.mayAnalyze = false;
            this.markForUpdate();
        }
    }

    @Nonnull
    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return this.func_70005_c_();
    }

    @Nonnull
    @Optional.Method(modid="opencomputers")
    public String[] methods() {
        return AgriApi.getPeripheralMethodRegistry().ids().toArray(new String[0]);
    }

    @Nullable
    @Optional.Method(modid="opencomputers")
    public Object[] invoke(@Nullable String methodName, Context context, @Nullable Arguments args) throws Exception {
        IAgriPeripheralMethod method = AgriApi.getPeripheralMethodRegistry().get(methodName).orElse(null);
        if (method == null) {
            return null;
        }
        Object[] argObjects = args == null ? null : args.toArray();
        try {
            return method.call((IBlockAccess)this.func_145831_w(), this.func_174877_v(), this.getJournal(), argObjects);
        }
        catch (IAgriPeripheralMethod.InvocationException e) {
            throw new Exception(e.getDescription());
        }
    }
}

