/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.event;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tschipp.carryon.CarryOn;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.CarryOnConfig;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.handler.PickupHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemEntity;
import tschipp.carryon.common.item.ItemTile;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;
import tschipp.carryon.network.client.CarrySlotPacket;

public class ItemEvents {
    public static Map<BlockPos, Integer> positions = new HashMap<BlockPos, Integer>();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack)) {
            String command;
            CarryOnOverride override;
            player.getEntityData().func_82580_o("carrySlot");
            event.setUseBlock(Event.Result.DENY);
            if (!player.field_70170_p.field_72995_K && (override = ScriptChecker.getOverride(player)) != null && (command = override.getCommandPlace()) != null) {
                player.func_184102_h().func_71187_D().func_71556_a((ICommandSender)player.func_184102_h(), "/execute " + player.func_146103_bH().getName() + " ~ ~ ~ " + command);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemDropped(EntityJoinWorldEvent event) {
        Entity e = event.getEntity();
        World world = event.getWorld();
        if (e instanceof EntityItem) {
            BlockPos pos;
            EntityItem eitem = (EntityItem)e;
            ItemStack stack = eitem.func_92059_d();
            Item item = stack.func_77973_b();
            if (item == RegistrationHandler.itemTile && ItemTile.hasTileData(stack)) {
                BlockPos finalPos = pos = eitem.func_180425_c();
                Block block = ItemTile.getBlock(stack);
                if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || !block.func_176196_c(world, pos)) {
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        BlockPos offsetPos = pos.func_177972_a(facing);
                        if (!world.func_180495_p(offsetPos).func_177230_c().func_176200_f((IBlockAccess)world, offsetPos) || !block.func_176196_c(world, offsetPos)) continue;
                        finalPos = offsetPos;
                        break;
                    }
                }
                world.func_175656_a(finalPos, ItemTile.getBlockState(stack));
                TileEntity tile = world.func_175625_s(finalPos);
                if (tile != null) {
                    tile.func_145839_a(ItemTile.getTileData(stack));
                    tile.func_174878_a(finalPos);
                }
                ItemTile.clearTileData(stack);
                eitem.func_92058_a(ItemStack.field_190927_a);
            }
            if (positions.containsKey(pos = new BlockPos(Math.floor(eitem.field_70165_t), Math.floor(eitem.field_70163_u), Math.floor(eitem.field_70161_v)))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayer) {
            EntityPlayer player = event.player;
            World world = player.func_130014_f_();
            ItemStack carried = player.func_184614_ca();
            if (!carried.func_190926_b() && carried.func_77973_b() == RegistrationHandler.itemTile || carried.func_77973_b() == RegistrationHandler.itemEntity) {
                if (carried.func_77973_b() == RegistrationHandler.itemTile) {
                    ItemTile cfr_ignored_0 = (ItemTile)carried.func_77973_b();
                    ItemTile cfr_ignored_1 = (ItemTile)carried.func_77973_b();
                    CarryOnOverride override = ScriptChecker.inspectBlock(ItemTile.getBlockState(carried), world, player.func_180425_c(), ItemTile.getTileData(carried));
                    if (override != null) {
                        CarryOn.network.sendTo((IMessage)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y(), override.hashCode()), (EntityPlayerMP)player);
                    } else {
                        CarryOn.network.sendTo((IMessage)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y()), (EntityPlayerMP)player);
                    }
                } else {
                    ItemEntity cfr_ignored_2 = (ItemEntity)carried.func_77973_b();
                    CarryOnOverride override = ScriptChecker.inspectEntity(ItemEntity.getEntity(carried, world));
                    if (override != null) {
                        CarryOn.network.sendTo((IMessage)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y(), override.hashCode()), (EntityPlayerMP)player);
                    } else {
                        CarryOn.network.sendTo((IMessage)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y()), (EntityPlayerMP)player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityStartTracking(PlayerEvent.StartTracking event) {
        Entity e = event.getTarget();
        EntityPlayer tracker = event.getEntityPlayer();
        if (e instanceof EntityPlayer && tracker instanceof EntityPlayerMP) {
            EntityPlayer player = (EntityPlayer)e;
            World world = player.func_130014_f_();
            ItemStack carried = player.func_184614_ca();
            if (!carried.func_190926_b() && carried.func_77973_b() == RegistrationHandler.itemTile || carried.func_77973_b() == RegistrationHandler.itemEntity) {
                if (carried.func_77973_b() == RegistrationHandler.itemTile) {
                    ItemTile cfr_ignored_0 = (ItemTile)carried.func_77973_b();
                    ItemTile cfr_ignored_1 = (ItemTile)carried.func_77973_b();
                    CarryOnOverride override = ScriptChecker.inspectBlock(ItemTile.getBlockState(carried), world, player.func_180425_c(), ItemTile.getTileData(carried));
                    if (override != null) {
                        CarryOn.network.sendTo((IMessage)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y(), override.hashCode()), (EntityPlayerMP)tracker);
                    } else {
                        CarryOn.network.sendTo((IMessage)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y()), (EntityPlayerMP)tracker);
                    }
                } else {
                    ItemEntity cfr_ignored_2 = (ItemEntity)carried.func_77973_b();
                    CarryOnOverride override = ScriptChecker.inspectEntity(ItemEntity.getEntity(carried, world));
                    if (override != null) {
                        CarryOn.network.sendTo((IMessage)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y(), override.hashCode()), (EntityPlayerMP)tracker);
                    } else {
                        CarryOn.network.sendTo((IMessage)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y()), (EntityPlayerMP)tracker);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void harvestSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack stack;
        EntityPlayer player = event.getEntityPlayer();
        if (!(player == null || CarryOnConfig.settings.hitWhileCarrying || (stack = player.func_184614_ca()).func_190926_b() || stack.func_77973_b() != RegistrationHandler.itemTile && stack.func_77973_b() != RegistrationHandler.itemEntity)) {
            event.setNewSpeed(0.0f);
        }
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        if (!(stack.func_190926_b() || CarryOnConfig.settings.hitWhileCarrying || stack.func_77973_b() != RegistrationHandler.itemTile && stack.func_77973_b() != RegistrationHandler.itemEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void harvestSpeed(BlockEvent.BreakEvent event) {
        ItemStack stack;
        EntityPlayer player = event.getPlayer();
        if (!(player == null || CarryOnConfig.settings.hitWhileCarrying || (stack = player.func_184614_ca()).func_190926_b() || stack.func_77973_b() != RegistrationHandler.itemTile && stack.func_77973_b() != RegistrationHandler.itemEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerAttack(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack stack;
        EntityLivingBase eliving = event.getEntityLiving();
        if (eliving instanceof EntityPlayer && CarryOnConfig.settings.dropCarriedWhenHit && !(stack = (player = (EntityPlayer)eliving).func_184614_ca()).func_190926_b() && (stack.func_77973_b() == RegistrationHandler.itemTile || stack.func_77973_b() == RegistrationHandler.itemEntity) && !player.field_70170_p.field_72995_K) {
            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            EntityItem item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
            ItemEvents.sendPacket(player, 9, 0);
            player.field_70170_p.func_72838_d((Entity)item);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        for (Map.Entry<BlockPos, Integer> entry : positions.entrySet()) {
            entry.setValue(entry.getValue() + 1);
            if (entry.getValue() <= 3) continue;
            positions.remove(entry.getKey());
        }
    }

    @SubscribeEvent
    public void onDrop(BlockEvent.HarvestDropsEvent event) {
        if (positions.containsKey(event.getPos())) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player instanceof EntityPlayerMP) {
            ItemStack main = player.func_184614_ca();
            ItemStack off = player.func_184592_cb();
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            Block block = world.func_180495_p(pos).func_177230_c();
            IBlockState state = world.func_180495_p(pos);
            if (main.func_190926_b() && off.func_190926_b() && CarryOnKeybinds.isKeyPressed(player)) {
                ItemStack stack = new ItemStack(RegistrationHandler.itemTile);
                TileEntity te = world.func_175625_s(pos);
                if (PickupHandler.canPlayerPickUpBlock(player, te, world, pos)) {
                    player.func_71053_j();
                    if (ItemTile.storeTileData(te, world, pos, state.func_185899_b((IBlockAccess)world, pos), stack)) {
                        String command;
                        IBlockState statee = world.func_180495_p(pos);
                        NBTTagCompound tag = new NBTTagCompound();
                        tag = world.func_175625_s(pos) != null ? world.func_175625_s(pos).func_189515_b(tag) : new NBTTagCompound();
                        CarryOnOverride override = ScriptChecker.inspectBlock(state, world, pos, tag);
                        int overrideHash = 0;
                        if (override != null) {
                            overrideHash = override.hashCode();
                        }
                        positions.put(pos, 0);
                        boolean success = false;
                        try {
                            ItemEvents.sendPacket(player, player.field_71071_by.field_70461_c, overrideHash);
                            world.func_175713_t(pos);
                            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                            player.func_184611_a(EnumHand.MAIN_HAND, stack);
                            event.setUseBlock(Event.Result.DENY);
                            event.setUseItem(Event.Result.DENY);
                            event.setCanceled(true);
                            success = true;
                        }
                        catch (Exception e) {
                            try {
                                ItemEvents.sendPacket(player, player.field_71071_by.field_70461_c, overrideHash);
                                ItemEvents.emptyTileEntity(te);
                                world.func_175698_g(pos);
                                player.func_184611_a(EnumHand.MAIN_HAND, stack);
                                event.setUseBlock(Event.Result.DENY);
                                event.setUseItem(Event.Result.DENY);
                                event.setCanceled(true);
                                success = true;
                            }
                            catch (Exception ex) {
                                ItemEvents.sendPacket(player, 9, 0);
                                world.func_175656_a(pos, statee);
                                if (!tag.func_82582_d()) {
                                    TileEntity.func_190200_a((World)world, (NBTTagCompound)tag);
                                }
                                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error detected. Cannot pick up block."));
                                TextComponentString s = new TextComponentString(TextFormatting.GOLD + "here");
                                s.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Tschipp/CarryOn/issues"));
                                player.func_145747_a(new TextComponentString(TextFormatting.RED + "Please report this error ").func_150257_a((ITextComponent)s));
                            }
                        }
                        if (success && override != null && (command = override.getCommandInit()) != null) {
                            player.func_184102_h().func_71187_D().func_71556_a((ICommandSender)player.func_184102_h(), "/execute " + player.func_146103_bH().getName() + " ~ ~ ~ " + command);
                        }
                    }
                }
            }
        }
    }

    public static void emptyTileEntity(TileEntity te) {
        if (te != null) {
            int i;
            IItemHandler itemHandler;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) continue;
                IItemHandler itemHandler2 = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
                for (int i2 = 0; i2 < itemHandler2.getSlots(); ++i2) {
                    itemHandler2.extractItem(i2, 64, false);
                }
            }
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (i = 0; i < itemHandler.getSlots(); ++i) {
                    itemHandler.extractItem(i, 64, false);
                }
            }
            if (te instanceof IInventory) {
                IInventory inv = (IInventory)te;
                inv.func_174888_l();
            }
            if (te instanceof IItemHandler) {
                itemHandler = (IItemHandler)te;
                for (i = 0; i < itemHandler.getSlots(); ++i) {
                    itemHandler.extractItem(i, 64, false);
                }
            }
            te.func_70296_d();
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.Clone event) {
        boolean wasCarrying;
        EntityPlayer original = event.getOriginal();
        EntityPlayer player = event.getEntityPlayer();
        boolean wasDead = event.isWasDeath();
        GameRules rules = player.field_70170_p.func_82736_K();
        boolean keepInv = rules.func_82766_b("keepInventory");
        boolean bl = wasCarrying = player.field_71071_by.func_70431_c(new ItemStack(RegistrationHandler.itemTile)) || player.field_71071_by.func_70431_c(new ItemStack(RegistrationHandler.itemEntity));
        if ((!wasDead || keepInv) && wasCarrying) {
            int carrySlot = original.field_71071_by.field_70461_c;
            ItemStack stack = player.field_71071_by.func_70304_b(carrySlot);
            World world = player.field_70170_p;
            EntityItem item = new EntityItem(world);
            item.func_92058_a(stack);
            BlockPos pos = original.func_180470_cg();
            if (pos == null) {
                pos = player.func_180425_c();
            }
            item.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            world.func_72838_d((Entity)item);
        }
    }

    @SubscribeEvent
    public void dropNonHotbarItems(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!entity.field_70170_p.field_72995_K) {
                String command;
                CarryOnOverride override;
                boolean hasCarried = player.field_71071_by.func_70431_c(new ItemStack(RegistrationHandler.itemTile)) || player.field_71071_by.func_70431_c(new ItemStack(RegistrationHandler.itemEntity));
                ItemStack inHand = player.func_184614_ca();
                if (hasCarried && inHand.func_77973_b() != RegistrationHandler.itemTile && inHand.func_77973_b() != RegistrationHandler.itemEntity) {
                    ItemStack dropped;
                    int slotBlock = this.getSlot(player, RegistrationHandler.itemTile);
                    int slotEntity = this.getSlot(player, RegistrationHandler.itemEntity);
                    EntityItem item = null;
                    if (slotBlock != -1) {
                        dropped = player.field_71071_by.func_70304_b(slotBlock);
                        item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, dropped);
                    }
                    if (slotEntity != -1) {
                        dropped = player.field_71071_by.func_70304_b(slotEntity);
                        item = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, dropped);
                    }
                    if (item != null) {
                        player.field_70170_p.func_72838_d(item);
                        ItemEvents.sendPacket(player, 9, 0);
                    }
                }
                if ((override = ScriptChecker.getOverride(player)) != null && (command = override.getCommandLoop()) != null) {
                    player.func_184102_h().func_71187_D().func_71556_a((ICommandSender)player.func_184102_h(), "/execute " + player.func_146103_bH().getName() + " ~ ~ ~ " + command);
                }
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("carryon")) {
            ListHandler.initLists();
            ConfigManager.load((String)"carryon", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public int getSlot(EntityPlayer player, Item item) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static void sendPacket(EntityPlayer player, int currentItem, int hash) {
        if (player instanceof EntityPlayerMP) {
            CarryOn.network.sendToAllAround((IMessage)new CarrySlotPacket(currentItem, player.func_145782_y(), hash), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 256.0));
            CarryOn.network.sendTo((IMessage)new CarrySlotPacket(currentItem, player.func_145782_y(), hash), (EntityPlayerMP)player);
            if (currentItem >= 9) {
                player.getEntityData().func_82580_o("carrySlot");
                player.getEntityData().func_82580_o("overrideKey");
            } else {
                player.getEntityData().func_74768_a("carrySlot", currentItem);
                if (hash != 0) {
                    ScriptChecker.setCarryOnOverride(player, hash);
                }
            }
        }
    }
}

