/*
 * Decompiled with CFR 0.152.
 */
package capsule.structure;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public class CapsulePlacementSettings
extends PlacementSettings {
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;
    private boolean ignoreEntities;
    @Nullable
    private Block replacedBlock;
    @Nullable
    private ChunkPos chunk;
    @Nullable
    private StructureBoundingBox boundingBox;
    private boolean ignoreStructureBlock = true;
    private float integrity = 1.0f;
    @Nullable
    private Random random;
    @Nullable
    private Long setSeed;

    public CapsulePlacementSettings copy() {
        CapsulePlacementSettings CapsulePlacementSettings2 = new CapsulePlacementSettings();
        CapsulePlacementSettings2.mirror = this.mirror;
        CapsulePlacementSettings2.rotation = this.rotation;
        CapsulePlacementSettings2.ignoreEntities = this.ignoreEntities;
        CapsulePlacementSettings2.replacedBlock = this.replacedBlock;
        CapsulePlacementSettings2.chunk = this.chunk;
        CapsulePlacementSettings2.boundingBox = this.boundingBox;
        CapsulePlacementSettings2.ignoreStructureBlock = this.ignoreStructureBlock;
        CapsulePlacementSettings2.integrity = this.integrity;
        CapsulePlacementSettings2.random = this.random;
        CapsulePlacementSettings2.setSeed = this.setSeed;
        return CapsulePlacementSettings2;
    }

    public CapsulePlacementSettings setMirror(Mirror mirrorIn) {
        this.mirror = mirrorIn;
        return this;
    }

    public CapsulePlacementSettings setRotation(Rotation rotationIn) {
        this.rotation = rotationIn;
        return this;
    }

    public CapsulePlacementSettings setIgnoreEntities(boolean ignoreEntitiesIn) {
        this.ignoreEntities = ignoreEntitiesIn;
        return this;
    }

    public CapsulePlacementSettings setReplacedBlock(Block replacedBlockIn) {
        this.replacedBlock = replacedBlockIn;
        return this;
    }

    public CapsulePlacementSettings setChunk(ChunkPos chunkPosIn) {
        this.chunk = chunkPosIn;
        return this;
    }

    public CapsulePlacementSettings setBoundingBox(StructureBoundingBox boundingBoxIn) {
        this.boundingBox = boundingBoxIn;
        return this;
    }

    public CapsulePlacementSettings setSeed(@Nullable Long seedIn) {
        this.setSeed = seedIn;
        return this;
    }

    public CapsulePlacementSettings setRandom(@Nullable Random randomIn) {
        this.random = randomIn;
        return this;
    }

    public CapsulePlacementSettings setIntegrity(float integrityIn) {
        this.integrity = integrityIn;
        return this;
    }

    public Mirror func_186212_b() {
        return this.mirror;
    }

    public CapsulePlacementSettings setIgnoreStructureBlock(boolean ignoreStructureBlockIn) {
        this.ignoreStructureBlock = ignoreStructureBlockIn;
        return this;
    }

    public Rotation func_186215_c() {
        return this.rotation;
    }

    public Random func_189947_a(@Nullable BlockPos seed) {
        if (this.random != null) {
            return this.random;
        }
        if (this.setSeed != null) {
            return this.setSeed == 0L ? new Random(System.currentTimeMillis()) : new Random(this.setSeed);
        }
        if (seed == null) {
            return new Random(System.currentTimeMillis());
        }
        int i = seed.func_177958_n();
        int j = seed.func_177952_p();
        return new Random((long)(i * i * 4987142 + i * 5947611) + (long)(j * j) * 4392871L + (long)(j * 389711) ^ 0x3AD8025FL);
    }

    public float func_189948_f() {
        return this.integrity;
    }

    public boolean func_186221_e() {
        return this.ignoreEntities;
    }

    @Nullable
    public Block func_186219_f() {
        return this.replacedBlock;
    }

    @Nullable
    public StructureBoundingBox func_186213_g() {
        if (this.boundingBox == null && this.chunk != null) {
            this.func_186224_i();
        }
        return this.boundingBox;
    }

    public boolean func_186227_h() {
        return this.ignoreStructureBlock;
    }

    void func_186224_i() {
        this.boundingBox = this.getBoundingBoxFromChunk(this.chunk);
    }

    @Nullable
    private StructureBoundingBox getBoundingBoxFromChunk(@Nullable ChunkPos pos) {
        if (pos == null) {
            return null;
        }
        int i = pos.field_77276_a * 16;
        int j = pos.field_77275_b * 16;
        return new StructureBoundingBox(i, 0, j, i + 16 - 1, 255, j + 16 - 1);
    }
}

