/*
 * Decompiled with CFR 0.152.
 */
package capsule.plugins.jei;

import capsule.Config;
import capsule.blocks.CapsuleBlocks;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.NonNullList;

@JEIPlugin
public class CapsulePlugin
implements IModPlugin {
    private static final int UPGRADE_STEP = 2;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter(CapsuleItems.capsule, (ISubtypeRegistry.ISubtypeInterpreter)new CapsuleSubtypeInterpreter());
    }

    public void register(@Nonnull IModRegistry registry) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        ItemStack ironCapsule = CapsuleItems.createCapsuleItemStack(0xCCCCCC, Config.ironCapsuleSize);
        ItemStack goldCapsule = CapsuleItems.createCapsuleItemStack(16766720, Config.goldCapsuleSize);
        ItemStack diamondCapsule = CapsuleItems.createCapsuleItemStack(65522, Config.diamondCapsuleSize);
        ItemStack opCapsule = CapsuleItems.createCapsuleItemStack(0xFFFFFF, Config.opCapsuleSize);
        opCapsule.func_77983_a("overpowered", (NBTBase)new NBTTagByte(1));
        Ingredient cfp = Ingredient.func_193367_a((Item)Items.field_185162_cT);
        for (int upLevel = 1; upLevel < Math.min(8, Config.upgradeLimit); ++upLevel) {
            this.registerUpgrade(recipes, ironCapsule, cfp, upLevel);
            this.registerUpgrade(recipes, goldCapsule, cfp, upLevel);
            this.registerUpgrade(recipes, diamondCapsule, cfp, upLevel);
            this.registerUpgrade(recipes, opCapsule, cfp, upLevel);
        }
        ItemStack unlabelledCapsule = this.getUnlabelledCapsule(ironCapsule);
        ItemStack recoveryCapsule = this.registerRecovery(recipes, ironCapsule, unlabelledCapsule);
        registry.addRecipes(recipes, "minecraft.crafting");
        registry.addIngredientInfo((Object)ironCapsule, ItemStack.class, new String[]{"jei.capsule.desc.capsule"});
        registry.addIngredientInfo((Object)unlabelledCapsule, ItemStack.class, new String[]{"jei.capsule.desc.linkedCapsule"});
        registry.addIngredientInfo((Object)recoveryCapsule, ItemStack.class, new String[]{"jei.capsule.desc.recoveryCapsule"});
        registry.addIngredientInfo((Object)opCapsule, ItemStack.class, new String[]{"jei.capsule.desc.opCapsule"});
        registry.addIngredientInfo((Object)new ItemStack((Block)CapsuleBlocks.blockCapsuleMarker), ItemStack.class, new String[]{"jei.capsule.desc.capsuleMarker"});
    }

    private ItemStack registerRecovery(List<IRecipe> recipes, ItemStack emptyCapsule, ItemStack unlabelledCapsule) {
        Ingredient unlabelledCapsuleIng = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{unlabelledCapsule});
        ItemStack recoveryCapsule = this.getRecoveryCapsule(emptyCapsule);
        recipes.add((IRecipe)new ShapelessRecipes("capsule", recoveryCapsule, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{unlabelledCapsuleIng, Ingredient.func_193367_a((Item)Items.field_151069_bo)})));
        recipes.add((IRecipe)new ShapelessRecipes("capsule", emptyCapsule, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{unlabelledCapsuleIng})));
        return recoveryCapsule;
    }

    private void registerUpgrade(List<IRecipe> recipes, ItemStack capsule, Ingredient upgradeIng, int upLevel) {
        ItemStack capsuleUp = this.getUpgradedCapsule(capsule, upLevel);
        Ingredient ironCapsuleIng = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{capsule});
        NonNullList ingredients = NonNullList.func_191197_a((int)(upLevel + 1), (Object)upgradeIng);
        ingredients.set(0, (Object)ironCapsuleIng);
        recipes.add((IRecipe)new ShapelessRecipes("capsule", capsuleUp, ingredients));
    }

    private ItemStack getUnlabelledCapsule(ItemStack capsule) {
        ItemStack unlabelledCapsule = capsule.func_77946_l();
        unlabelledCapsule.func_77964_b(2);
        CapsuleItem.setStructureName(unlabelledCapsule, "JEIExemple");
        return unlabelledCapsule;
    }

    private ItemStack getRecoveryCapsule(ItemStack capsule) {
        ItemStack recoveryCapsule = capsule.func_77946_l();
        CapsuleItem.setOneUse(recoveryCapsule);
        CapsuleItem.setStructureName(recoveryCapsule, "JEIExemple");
        return recoveryCapsule;
    }

    private ItemStack getUpgradedCapsule(ItemStack ironCapsule, int upLevel) {
        ItemStack capsuleUp = ironCapsule.func_77946_l();
        CapsuleItem.setSize(capsuleUp, CapsuleItem.getSize(ironCapsule) + upLevel * 2);
        CapsuleItem.setUpgradeLevel(capsuleUp, upLevel);
        capsuleUp.func_77983_a("upgraded", (NBTBase)new NBTTagInt(upLevel));
        return capsuleUp;
    }

    private static class CapsuleSubtypeInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter {
        private CapsuleSubtypeInterpreter() {
        }

        public String apply(ItemStack itemStack) {
            if (!(itemStack.func_77973_b() instanceof CapsuleItem)) {
                return null;
            }
            String isOP = String.valueOf(itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("overpowered") && itemStack.func_77978_p().func_74767_n("overpowered"));
            String capsuleState = String.valueOf(itemStack.func_77952_i());
            String capsuleColor = String.valueOf(CapsuleItem.getMaterialColor(itemStack));
            return capsuleState + capsuleColor + isOP;
        }
    }
}

