/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LabelEditedMessageToServer
implements IMessage {
    protected static final Logger LOGGER = LogManager.getLogger(LabelEditedMessageToServer.class);
    private String label;
    private boolean messageIsValid;

    public LabelEditedMessageToServer(String newLabel) {
        this.setLabel(newLabel);
        this.messageIsValid = true;
    }

    public LabelEditedMessageToServer() {
        this.messageIsValid = false;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.setLabel(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        catch (IndexOutOfBoundsException ioe) {
            LOGGER.error("Exception while reading CapsuleLabelEditedMessageToClient: " + ioe);
            return;
        }
        this.messageIsValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageIsValid) {
            return;
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.getLabel());
    }

    public String toString() {
        return "CapsuleLabelEditedMessageToClient[label=" + String.valueOf(this.getLabel()) + "]";
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

