/*
 * Decompiled with CFR 0.152.
 */
package capsule.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapsuleContentPreviewAnswerToClient
implements IMessage {
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleContentPreviewAnswerToClient.class);
    private List<BlockPos> blockPositions = null;
    private String structureName = null;

    public CapsuleContentPreviewAnswerToClient(List<BlockPos> blockPositions, String structureName) {
        this.blockPositions = blockPositions;
        this.structureName = structureName;
    }

    public CapsuleContentPreviewAnswerToClient() {
    }

    public void fromBytes(ByteBuf buf) {
        try {
            int size = buf.readShort();
            this.blockPositions = new ArrayList<BlockPos>(size);
            for (int i = 0; i < size; ++i) {
                this.blockPositions.add(BlockPos.func_177969_a((long)buf.readLong()));
            }
            this.structureName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        catch (IndexOutOfBoundsException ioe) {
            LOGGER.error("Exception while reading CapsuleContentPreviewMessageToClient: " + ioe);
            return;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.blockPositions.size());
        for (BlockPos pos : this.blockPositions) {
            buf.writeLong(pos.func_177986_g());
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.structureName);
    }

    public String toString() {
        return "CapsuleContentPreviewMessageToClient";
    }

    public List<BlockPos> getBlockPositions() {
        return this.blockPositions;
    }

    public String getStructureName() {
        return this.structureName;
    }
}

