/*
 * Decompiled with CFR 0.152.
 */
package capsule.loot;

import capsule.Config;
import capsule.loot.CapsuleLootEntry;
import java.util.ArrayList;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapsuleLootTableHook {
    private static final int DEFAULT_WEIGHT = 3;
    public static LootPool capsulePool = null;

    @SubscribeEvent
    public void hookCapsulesOnLootTable(LootTableLoadEvent event) {
        if (!Config.lootTablesList.contains(event.getName().toString())) {
            return;
        }
        if (capsulePool == null) {
            ArrayList<CapsuleLootEntry> entries = new ArrayList<CapsuleLootEntry>();
            for (String path : Config.lootTemplatesPaths) {
                int weight = this.findConfiguredWeight(path);
                entries.add(new CapsuleLootEntry(path, weight, 0, new LootCondition[0], "capsule:capsuleLootsEntry" + path.replace("/", "_")));
            }
            capsulePool = new LootPool(entries.toArray(new LootEntry[0]), new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "capsulePool");
        }
        event.getTable().addPool(capsulePool);
    }

    public int findConfiguredWeight(String path) {
        int weight = 3;
        if (Config.lootTemplatesData.containsKey(path)) {
            weight = Config.lootTemplatesData.get((Object)path).weigth;
        }
        return weight;
    }
}

