/*
 * Decompiled with CFR 0.152.
 */
package capsule.items.recipes;

import capsule.Config;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class UpgradeCapsuleRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final Item upgradeItem;

    public UpgradeCapsuleRecipe(Item upgradeItem) {
        this.upgradeItem = upgradeItem;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }

    public boolean func_77569_a(InventoryCrafting craftingGrid, World worldIn) {
        ItemStack sourceCapsule = ItemStack.field_190927_a;
        int material = 0;
        for (int i = 0; i < craftingGrid.func_174923_h(); ++i) {
            for (int j = 0; j < craftingGrid.func_174922_i(); ++j) {
                ItemStack itemstack = craftingGrid.func_70463_b(j, i);
                if (!itemstack.func_190926_b() && itemstack.func_77973_b() == CapsuleItems.capsule && itemstack.func_77952_i() == 0 && CapsuleItem.getUpgradeLevel(itemstack) < Config.upgradeLimit) {
                    sourceCapsule = itemstack;
                    continue;
                }
                if (!itemstack.func_190926_b() && itemstack.func_77973_b() == this.upgradeItem) {
                    ++material;
                    continue;
                }
                if (itemstack.func_190926_b()) continue;
                return false;
            }
        }
        return sourceCapsule != null && material > 0 && CapsuleItem.getUpgradeLevel(sourceCapsule) + material <= Config.upgradeLimit;
    }

    public ItemStack func_77572_b(InventoryCrafting craftingGrid) {
        ItemStack input = ItemStack.field_190927_a;
        int material = 0;
        for (int i = 0; i < craftingGrid.func_174923_h(); ++i) {
            for (int j = 0; j < craftingGrid.func_174922_i(); ++j) {
                ItemStack itemstack = craftingGrid.func_70463_b(j, i);
                if (!itemstack.func_190926_b() && itemstack.func_77973_b() == CapsuleItems.capsule && itemstack.func_77952_i() == 0 && CapsuleItem.getUpgradeLevel(itemstack) < Config.upgradeLimit) {
                    input = itemstack;
                    continue;
                }
                if (!itemstack.func_190926_b() && itemstack.func_77973_b() == this.upgradeItem) {
                    ++material;
                    continue;
                }
                if (itemstack.func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
        }
        if (input == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = input.func_77946_l();
        int newSize = CapsuleItem.getSize(input) + material * 2;
        int newUpgraded = CapsuleItem.getUpgradeLevel(input) + material;
        if (newSize > 31) {
            newSize = 31;
        }
        if (newUpgraded > Config.upgradeLimit) {
            newUpgraded = Config.upgradeLimit;
        }
        CapsuleItem.setSize(copy, newSize);
        CapsuleItem.setUpgradeLevel(copy, newUpgraded);
        return copy;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public boolean func_192399_d() {
        return true;
    }
}

