/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.CapsuleSavedData;
import capsule.Config;
import capsule.items.CapsuleItem;
import capsule.loot.LootPathData;
import capsule.structure.CapsulePlacementSettings;
import capsule.structure.CapsuleTemplate;
import capsule.structure.CapsuleTemplateManager;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureSaver {
    protected static final Logger LOGGER = LogManager.getLogger(StructureSaver.class);
    public static Map<String, CapsuleTemplateManager> CapsulesManagers = new HashMap<String, CapsuleTemplateManager>();
    private static CapsuleTemplateManager RewardManager = null;

    public static void loadLootList(MinecraftServer server) {
        for (int i = 0; i < Config.lootTemplatesPaths.length; ++i) {
            String path = Config.lootTemplatesPaths[i];
            LootPathData data = Config.lootTemplatesData.get(path);
            File templateFolder = new File(server.func_71238_n(), path);
            if (path.startsWith("config/") && !templateFolder.exists()) {
                templateFolder.mkdirs();
                LOGGER.info("First load: initializing the loots in config/capsule/loot. You can change the content of folder with any nbt structure block or capsule file. You can remove the folders from capsule.config to remove loots.");
                StructureSaver.populateFolder(templateFolder);
            }
            if (!templateFolder.exists() || !templateFolder.isDirectory()) continue;
            File[] fileList = templateFolder.listFiles((p_accept_1_, p_accept_2_) -> p_accept_2_.endsWith(".nbt"));
            data.files = new ArrayList<String>();
            if (fileList == null) continue;
            for (File templateFile : fileList) {
                if (!templateFile.isFile() || !templateFile.getName().endsWith(".nbt")) continue;
                data.files.add(templateFile.getName().replaceAll(".nbt", ""));
            }
        }
    }

    private static void populateFolder(File templateFolder) {
        try {
            String[] resources;
            String assetPath = "assets/capsule/loot/common";
            if (templateFolder.getPath().contains("uncommon")) {
                assetPath = "assets/capsule/loot/uncommon";
            }
            if (templateFolder.getPath().contains("rare")) {
                assetPath = "assets/capsule/loot/rare";
            }
            for (String ressource : resources = StructureSaver.getResourceListing(StructureSaver.class, assetPath)) {
                if (ressource.isEmpty()) continue;
                InputStream sourceTemplate = StructureSaver.class.getClassLoader().getResourceAsStream(assetPath + "/" + ressource);
                Path assetFile = templateFolder.toPath().resolve(ressource.toLowerCase());
                LOGGER.debug("copying template " + assetPath + "/" + ressource + " to " + assetFile.toString());
                try {
                    Files.copy(sourceTemplate, assetFile, new CopyOption[0]);
                }
                catch (Exception e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while copying initial capsule templates, there will be no loots!", (Throwable)e);
        }
    }

    public static String[] getResourceListing(Class<?> clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            LOGGER.debug("Listing files in " + jarPath);
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path)) continue;
                LOGGER.debug("Found in jar " + name);
                String entry = name.replace(path + "/", "");
                LOGGER.debug("Keeping " + entry);
                result.add(entry);
            }
            jar.close();
            return result.toArray(new String[result.size()]);
        }
        InputStream inputstream = clazz.getResourceAsStream("/" + path);
        if (inputstream != null) {
            InputStreamReader isr = new InputStreamReader(inputstream, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isr);
            HashSet<String> result = new HashSet<String>();
            String filename = null;
            while ((filename = br.readLine()) != null) {
                result.add(filename);
            }
            return result.toArray(new String[result.size()]);
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    public static CapsuleTemplateManager getRewardManager(MinecraftServer server) {
        if (RewardManager == null) {
            RewardManager = new CapsuleTemplateManager(server.func_71238_n().getPath(), (DataFixer)FMLCommonHandler.instance().getDataFixer());
            File rewardDir = new File(Config.rewardTemplatesPath);
            if (!rewardDir.exists()) {
                rewardDir.mkdirs();
            }
        }
        return RewardManager;
    }

    public static boolean store(WorldServer worldserver, String playerID, String capsuleStructureId, BlockPos startPos, int size, List<Block> excluded, Map<BlockPos, Block> excludedPositions) {
        boolean writingOK;
        MinecraftServer minecraftserver = worldserver.func_73046_m();
        ArrayList<Entity> outCapturedEntities = new ArrayList<Entity>();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(worldserver);
        CapsuleTemplate template = templatemanager.getTemplate(minecraftserver, new ResourceLocation(capsuleStructureId));
        List<BlockPos> transferedPositions = template.takeBlocksFromWorldIntoCapsule((World)worldserver, startPos, new BlockPos(size, size, size), excludedPositions, excluded, outCapturedEntities);
        EntityPlayer player = null;
        if (playerID != null) {
            template.setAuthor(playerID);
            player = worldserver.func_72924_a(playerID);
        }
        if (writingOK = templatemanager.writeTemplate(minecraftserver, new ResourceLocation(capsuleStructureId))) {
            List<BlockPos> couldNotBeRemoved = StructureSaver.removeTransferedBlockFromWorld(transferedPositions, worldserver, player);
            for (Entity e : outCapturedEntities) {
                e.func_184174_b(false);
                e.func_70106_y();
            }
            if (couldNotBeRemoved != null) {
                template.removeBlocks(couldNotBeRemoved, startPos);
                templatemanager.writeTemplate(minecraftserver, new ResourceLocation(capsuleStructureId));
            }
        } else if (player != null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.technicalError", new Object[0]));
        }
        return writingOK;
    }

    public static CapsuleTemplateManager getTemplateManager(WorldServer worldserver) {
        if (worldserver == null) {
            return null;
        }
        File directory = worldserver.func_72860_G().func_75765_b();
        String directoryPath = directory.getPath();
        if (!CapsulesManagers.containsKey(directoryPath)) {
            File capsuleDir = new File(directory, "structures/capsule");
            capsuleDir.mkdirs();
            CapsulesManagers.put(directoryPath, new CapsuleTemplateManager(capsuleDir.toString(), (DataFixer)FMLCommonHandler.instance().getDataFixer()));
        }
        return CapsulesManagers.get(directoryPath);
    }

    public static List<BlockPos> removeTransferedBlockFromWorld(List<BlockPos> transferedPositions, WorldServer world, EntityPlayer player) {
        ArrayList<BlockPos> couldNotBeRemoved = null;
        boolean flagdoTileDrops = world.func_82736_K().func_82766_b("doTileDrops");
        world.func_82736_K().func_82764_b("doTileDrops", "false");
        world.restoringBlockSnapshots = true;
        for (BlockPos pos : transferedPositions) {
            IBlockState b = world.func_180495_p(pos);
            try {
                if (StructureSaver.playerCanRemove(world, pos, player)) {
                    world.func_175698_g(pos);
                    continue;
                }
                if (couldNotBeRemoved == null) {
                    couldNotBeRemoved = new ArrayList<BlockPos>();
                }
                couldNotBeRemoved.add(pos);
            }
            catch (Exception e) {
                LOGGER.error("Block crashed during Capsule capture phase : couldn't be removed. Will be ignored.", (Throwable)e);
                if (player != null) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.technicalError", new Object[0]));
                }
                try {
                    world.func_175656_a(pos, b);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (couldNotBeRemoved == null) {
                    couldNotBeRemoved = new ArrayList();
                }
                couldNotBeRemoved.add(pos);
            }
        }
        world.restoringBlockSnapshots = false;
        world.func_82736_K().func_82764_b("doTileDrops", String.valueOf(flagdoTileDrops));
        return couldNotBeRemoved;
    }

    public static boolean clearTemplate(WorldServer worldserver, String capsuleStructureId) {
        MinecraftServer minecraftserver = worldserver.func_73046_m();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(worldserver);
        CapsuleTemplate template = templatemanager.getTemplate(minecraftserver, new ResourceLocation(capsuleStructureId));
        List<Template.BlockInfo> blocks = template.blocks;
        List<Template.EntityInfo> entities = template.entities;
        blocks.clear();
        entities.clear();
        return templatemanager.writeTemplate(minecraftserver, new ResourceLocation(capsuleStructureId));
    }

    public static boolean deploy(ItemStack capsule, WorldServer playerWorld, String thrower, BlockPos dest, List<Block> overridableBlocks, Map<BlockPos, Block> outOccupiedSpawnPositions, List<String> outEntityBlocking) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> templatepair = StructureSaver.getTemplate(capsule, playerWorld);
        CapsuleTemplate template = (CapsuleTemplate)templatepair.getRight();
        EntityPlayer player = null;
        if (thrower != null) {
            player = playerWorld.func_72924_a(thrower);
        }
        if (template != null) {
            int size = CapsuleItem.getSize(capsule);
            CapsulePlacementSettings placementsettings = new CapsulePlacementSettings().setMirror(Mirror.NONE).setRotation(Rotation.NONE).setIgnoreEntities(false).setChunk(null).setReplacedBlock(null).setIgnoreStructureBlock(false);
            boolean destValid = StructureSaver.isDestinationValid(template, placementsettings, playerWorld, dest, size, overridableBlocks, outOccupiedSpawnPositions, outEntityBlocking);
            if (destValid) {
                ArrayList<BlockPos> spawnedBlocks = new ArrayList<BlockPos>();
                ArrayList<Entity> spawnedEntities = new ArrayList<Entity>();
                try {
                    if (player != null && !StructureSaver.playerCanPlace(playerWorld, dest, template, player, placementsettings)) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.notAllowed", new Object[0]));
                        return false;
                    }
                    template.spawnBlocksAndEntities((World)playerWorld, dest, placementsettings, spawnedBlocks, spawnedEntities);
                    return true;
                }
                catch (Exception err) {
                    LOGGER.error("Couldn't deploy the capsule", (Throwable)err);
                    if (player != null) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.technicalError", new Object[0]));
                    }
                    StructureSaver.removeTransferedBlockFromWorld(spawnedBlocks, playerWorld, player);
                    for (Entity e : spawnedEntities) {
                        e.func_184174_b(false);
                        e.func_70106_y();
                    }
                }
            } else if (player != null) {
                if (outOccupiedSpawnPositions.size() == 0) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.cantMergeWithDestinationEntity", new Object[]{StringUtils.join(outEntityBlocking, (String)", ")}));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.cantMergeWithDestination", new Object[0]));
                }
            }
        } else if (player != null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("capsule.error.capsuleContentNotFound", new Object[]{CapsuleItem.getStructureName(capsule)}));
        }
        return false;
    }

    private static boolean playerCanPlace(WorldServer worldserver, BlockPos dest, CapsuleTemplate template, EntityPlayer player, CapsulePlacementSettings placementsettings) {
        if (player != null) {
            List<BlockPos> expectedOut = template.calculateDeployPositions((World)worldserver, dest, placementsettings);
            for (BlockPos blockPos : expectedOut) {
                BlockSnapshot blocksnapshot = new BlockSnapshot((World)worldserver, blockPos, Blocks.field_150350_a.func_176223_P());
                BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blocksnapshot, Blocks.field_150346_d.func_176223_P(), player, EnumHand.MAIN_HAND);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean playerCanRemove(WorldServer worldserver, BlockPos blockPos, EntityPlayer player) {
        if (player != null) {
            BlockSnapshot blocksnapshot = new BlockSnapshot((World)worldserver, blockPos, Blocks.field_150350_a.func_176223_P());
            BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blocksnapshot, Blocks.field_150346_d.func_176223_P(), player, EnumHand.MAIN_HAND);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return false;
            }
        }
        return true;
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplate(ItemStack capsule, WorldServer playerWorld) {
        Pair<CapsuleTemplateManager, CapsuleTemplate> template = null;
        boolean isReward = CapsuleItem.isReward(capsule);
        String structureName = CapsuleItem.getStructureName(capsule);
        template = isReward ? StructureSaver.getTemplateForReward(playerWorld.func_73046_m(), structureName) : StructureSaver.getTemplateForCapsule(playerWorld, structureName);
        return template;
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplateForCapsule(WorldServer playerWorld, String structureName) {
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(playerWorld);
        if (templatemanager == null || Strings.isNullOrEmpty((String)structureName)) {
            return Pair.of(null, null);
        }
        CapsuleTemplate template = templatemanager.getTemplate(playerWorld.func_73046_m(), new ResourceLocation(structureName));
        return Pair.of((Object)templatemanager, (Object)template);
    }

    public static Pair<CapsuleTemplateManager, CapsuleTemplate> getTemplateForReward(MinecraftServer server, String structurePath) {
        CapsuleTemplateManager templatemanager = StructureSaver.getRewardManager(server);
        if (templatemanager == null || Strings.isNullOrEmpty((String)structurePath)) {
            return Pair.of(null, null);
        }
        CapsuleTemplate template = templatemanager.getTemplate(server, new ResourceLocation(structurePath));
        return Pair.of((Object)templatemanager, (Object)template);
    }

    public static boolean isDestinationValid(CapsuleTemplate template, CapsulePlacementSettings placementIn, WorldServer destWorld, BlockPos destOriginPos, int size, List<Block> overridable, Map<BlockPos, Block> outOccupiedPositions, List<String> outEntityBlocking) {
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        List<Template.BlockInfo> srcblocks = template.blocks;
        if (srcblocks == null) {
            return false;
        }
        HashMap<BlockPos, Template.BlockInfo> blockInfoByPosition = new HashMap<BlockPos, Template.BlockInfo>();
        for (Template.BlockInfo template$blockinfo : srcblocks) {
            BlockPos blockpos = CapsuleTemplate.transformedBlockPos(placementIn, template$blockinfo.field_186242_a);
            blockInfoByPosition.put(blockpos, template$blockinfo);
        }
        for (int y = size - 1; y >= 0; --y) {
            for (int x = 0; x < size; ++x) {
                for (int z = 0; z < size; ++z) {
                    BlockPos destPos;
                    IBlockState destState;
                    boolean destOccupied;
                    BlockPos srcPos = new BlockPos(x, y, z);
                    Template.BlockInfo srcInfo = (Template.BlockInfo)blockInfoByPosition.get(srcPos);
                    IBlockState srcState = air;
                    if (srcInfo != null) {
                        srcState = srcInfo.field_186243_b;
                    }
                    boolean bl = destOccupied = (destState = destWorld.func_180495_p(destPos = destOriginPos.func_177982_a(x, y, z))) != air && !overridable.contains(destState.func_177230_c());
                    if (destState != air && outOccupiedPositions != null) {
                        outOccupiedPositions.put(destPos, destState.func_177230_c());
                    }
                    boolean srcOccupied = srcState != air && !overridable.contains(srcState.func_177230_c());
                    List entities = destWorld.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)destPos.func_177958_n(), (double)destPos.func_177956_o(), (double)destPos.func_177952_p(), (double)(destPos.func_177958_n() + 1), (double)(destPos.func_177956_o() + 1), (double)(destPos.func_177952_p() + 1)));
                    if ((entities.size() <= 0 || !srcOccupied) && (!destOccupied || overridable.contains(srcState.func_177230_c()))) continue;
                    if (entities.size() > 0 && outEntityBlocking != null) {
                        for (Object e : entities) {
                            Entity entity = (Entity)e;
                            if (entity == null) continue;
                            outEntityBlocking.add(entity.func_70005_c_());
                        }
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public static String getUniqueName(WorldServer playerWorld, String player) {
        CapsuleSavedData csd = StructureSaver.getCapsuleSavedData(playerWorld);
        String capsuleID = "C-" + player + "-" + csd.getNextCount();
        CapsuleTemplateManager templatemanager = StructureSaver.getTemplateManager(playerWorld);
        while (templatemanager.get(playerWorld.func_73046_m(), new ResourceLocation(capsuleID)) != null) {
            capsuleID = "C-" + player + "-" + csd.getNextCount();
        }
        return capsuleID;
    }

    public static CapsuleSavedData getCapsuleSavedData(WorldServer capsuleWorld) {
        CapsuleSavedData capsuleSavedData = (CapsuleSavedData)capsuleWorld.func_72943_a(CapsuleSavedData.class, "capsuleData");
        if (capsuleSavedData == null) {
            capsuleSavedData = new CapsuleSavedData("capsuleData");
            capsuleWorld.func_72823_a("capsuleData", (WorldSavedData)capsuleSavedData);
            capsuleSavedData.func_76186_a(true);
        }
        return capsuleSavedData;
    }
}

