/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.Config;
import capsule.StructureSaver;
import capsule.blocks.CapsuleBlocks;
import capsule.command.CapsuleCommand;
import capsule.enchantments.Enchantments;
import capsule.items.CapsuleItems;
import capsule.loot.CapsuleLootTableHook;
import capsule.network.CapsuleContentPreviewAnswerHandler;
import capsule.network.CapsuleContentPreviewAnswerToClient;
import capsule.network.CapsuleContentPreviewQueryHandler;
import capsule.network.CapsuleContentPreviewQueryToServer;
import capsule.network.CapsuleThrowQueryHandler;
import capsule.network.CapsuleThrowQueryToServer;
import capsule.network.LabelEditedMessageToServer;
import capsule.network.LabelEditedMessageToServerMessageHandler;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
public class CommonProxy {
    public static SimpleNetworkWrapper simpleNetworkWrapper;
    public static byte CAPSULE_CHANNEL_MESSAGE_ID;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        CapsuleBlocks.registerBlocks(event);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        CapsuleBlocks.registerItemBlocks(event);
        CapsuleItems.registerItems(event);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        CapsuleItems.registerRecipes(event);
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        Enchantments.registerEnchantments(event);
    }

    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        Config.readConfig(config);
        Config.initLootConfigs();
        Config.initReceipeConfigs();
        Config.initEnchantsConfigs();
        simpleNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("CapsuleChannel");
        byte by = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by + 1);
        simpleNetworkWrapper.registerMessage(LabelEditedMessageToServerMessageHandler.class, LabelEditedMessageToServer.class, (int)by, Side.SERVER);
        byte by2 = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by2 + 1);
        simpleNetworkWrapper.registerMessage(CapsuleContentPreviewQueryHandler.class, CapsuleContentPreviewQueryToServer.class, (int)by2, Side.SERVER);
        byte by3 = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by3 + 1);
        simpleNetworkWrapper.registerMessage(CapsuleThrowQueryHandler.class, CapsuleThrowQueryToServer.class, (int)by3, Side.SERVER);
        byte by4 = CAPSULE_CHANNEL_MESSAGE_ID;
        CAPSULE_CHANNEL_MESSAGE_ID = (byte)(by4 + 1);
        simpleNetworkWrapper.registerMessage(CapsuleContentPreviewAnswerHandler.class, CapsuleContentPreviewAnswerToClient.class, (int)by4, Side.CLIENT);
    }

    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)Enchantments.recallEnchant);
    }

    public void postInit(FMLPostInitializationEvent event) {
        Config.initCaptureConfigs();
        Config.config.save();
        if (Config.config.hasChanged()) {
            Config.config.save();
        }
        CapsuleLootTableHook lootTableHook = new CapsuleLootTableHook();
        MinecraftForge.EVENT_BUS.register((Object)lootTableHook);
    }

    public void serverStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CapsuleCommand());
        StructureSaver.loadLootList(e.getServer());
    }

    public void openGuiScreen(EntityPlayer playerIn) {
    }

    static {
        CAPSULE_CHANNEL_MESSAGE_ID = 1;
    }
}

